/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.instancio.PredicateSelector;
import org.instancio.Scope;
import org.instancio.TargetSelector;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.ScopelessSelector;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.selectors.SelectorTargetKind;
import org.instancio.internal.util.ReflectionUtils;

final class SelectorMap<V> {
    private static final boolean FIND_ONE_ONLY = true;
    private static final ScopelessSelector SCOPELESS_ROOT = new ScopelessSelector(SelectorImpl.getRootSelector().getTargetClass());
    private final Map<ScopelessSelector, List<SelectorImpl>> scopelessSelectors = new LinkedHashMap<ScopelessSelector, List<SelectorImpl>>();
    private final Map<? super TargetSelector, V> selectors = new LinkedHashMap<TargetSelector, V>();
    private final Set<? super TargetSelector> unusedSelectors = new LinkedHashSet<TargetSelector>();
    private final List<PredicateSelectorEntry<V>> predicateSelectors = new ArrayList<PredicateSelectorEntry<V>>();

    SelectorMap() {
    }

    void put(TargetSelector targetSelector, V value) {
        if (targetSelector instanceof SelectorImpl) {
            ScopelessSelector scopeless;
            SelectorImpl selector = (SelectorImpl)targetSelector;
            if (selector.isFieldSelector()) {
                Field field = ReflectionUtils.getField(selector.getTargetClass(), selector.getFieldName());
                scopeless = new ScopelessSelector(field.getDeclaringClass(), field);
            } else {
                scopeless = new ScopelessSelector(selector.getTargetClass());
            }
            this.selectors.put(selector, value);
            this.unusedSelectors.add(selector);
            this.scopelessSelectors.computeIfAbsent(scopeless, selectorList -> new ArrayList()).add(selector);
        } else if (targetSelector instanceof PredicateSelector) {
            PredicateSelectorImpl selector = (PredicateSelectorImpl)targetSelector;
            this.predicateSelectors.add(new PredicateSelectorEntry(selector, value));
        }
    }

    public Set<? super TargetSelector> getUnusedKeys() {
        HashSet<? super TargetSelector> unused = new HashSet<TargetSelector>(this.unusedSelectors);
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (((PredicateSelectorEntry)entry).matched) continue;
            unused.add(((PredicateSelectorEntry)entry).predicateSelector);
        }
        return unused;
    }

    Optional<V> getValue(Node node) {
        Optional<Object> value = SelectorMap.getSelectorsWithParent(node, this.getCandidates(node), true).stream().findFirst().map(this::markUsed).map(this.selectors::get);
        if (value.isPresent()) {
            return value;
        }
        return this.getPredicateSelectorMatch(node);
    }

    private Optional<V> getPredicateSelectorMatch(Node node) {
        PredicateSelectorEntry<V> classPredicate = null;
        for (int i = this.predicateSelectors.size() - 1; i >= 0; --i) {
            PredicateSelectorEntry<V> entry = this.predicateSelectors.get(i);
            if (((PredicateSelectorEntry)entry).predicateSelector.getSelectorTargetKind() == SelectorTargetKind.FIELD) {
                if (!SelectorMap.isPredicateMatch(node, entry)) continue;
                ((PredicateSelectorEntry)entry).matched = true;
                return Optional.of(((PredicateSelectorEntry)entry).value);
            }
            if (classPredicate != null || ((PredicateSelectorEntry)entry).predicateSelector.getSelectorTargetKind() != SelectorTargetKind.CLASS || !SelectorMap.isPredicateMatch(node, entry)) continue;
            classPredicate = entry;
        }
        if (classPredicate != null) {
            ((PredicateSelectorEntry)classPredicate).matched = true;
            return Optional.of(((PredicateSelectorEntry)classPredicate).value);
        }
        return Optional.empty();
    }

    List<V> getValues(Node node) {
        List values = SelectorMap.getSelectorsWithParent(node, this.getCandidates(node), false).stream().map(this::markUsed).map(this.selectors::get).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<Object> valuesMatchingPredicates = new ArrayList<Object>();
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (!SelectorMap.isPredicateMatch(node, entry)) continue;
            ((PredicateSelectorEntry)entry).matched = true;
            valuesMatchingPredicates.add(((PredicateSelectorEntry)entry).value);
        }
        values.addAll(valuesMatchingPredicates);
        return values;
    }

    private static boolean isPredicateMatch(Node node, PredicateSelectorEntry<?> entry) {
        return ((PredicateSelectorEntry)entry).predicateSelector.getSelectorTargetKind() == SelectorTargetKind.FIELD ? ((PredicateSelectorEntry)entry).predicateSelector.getFieldPredicate().test(node.getField()) : ((PredicateSelectorEntry)entry).predicateSelector.getClassPredicate().test(node.getTargetClass());
    }

    private SelectorImpl markUsed(SelectorImpl selector) {
        if (selector.getParent() instanceof PrimitiveAndWrapperSelectorImpl) {
            SelectorImpl equivalent = SelectorImpl.builder(selector).targetClass(PrimitiveWrapperBiLookup.getEquivalent(selector.getTargetClass())).build();
            this.unusedSelectors.remove(equivalent);
        }
        this.unusedSelectors.remove(selector);
        return selector;
    }

    private List<SelectorImpl> getCandidates(Node node) {
        if (node.getParent() == null && this.scopelessSelectors.containsKey(SCOPELESS_ROOT)) {
            return Collections.singletonList(SelectorImpl.getRootSelector());
        }
        ArrayList<SelectorImpl> candidates = new ArrayList<SelectorImpl>(this.scopelessSelectors.getOrDefault(new ScopelessSelector(node.getRawType()), Collections.emptyList()));
        if (node.getField() != null) {
            List fieldSelectors = this.scopelessSelectors.getOrDefault(new ScopelessSelector(node.getField().getDeclaringClass(), node.getField()), Collections.emptyList());
            candidates.addAll(fieldSelectors);
        }
        return candidates;
    }

    private static List<SelectorImpl> getSelectorsWithParent(Node targetNode, List<SelectorImpl> candidates, boolean findOneOnly) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SelectorImpl> results = new ArrayList<SelectorImpl>();
        for (int i = candidates.size() - 1; i >= 0 && (!findOneOnly || results.isEmpty()); --i) {
            SelectorImpl candidate = candidates.get(i);
            if (!SelectorMap.selectorScopesMatchNodeHierarchy(candidate, targetNode)) continue;
            results.add(candidate);
        }
        return results;
    }

    private static boolean selectorScopesMatchNodeHierarchy(SelectorImpl candidate, Node targetNode) {
        if (candidate.getScopes().isEmpty()) {
            return true;
        }
        ArrayDeque<Scope> deq = new ArrayDeque<Scope>(candidate.getScopes());
        ScopeImpl scope = (ScopeImpl)deq.removeLast();
        for (Node node = targetNode; node != null; node = node.getParent()) {
            if (scope.isFieldScope()) {
                if (scope.resolveField().equals(node.getField())) {
                    scope = (ScopeImpl)deq.pollLast();
                }
            } else if (node.getRawType().equals(scope.getTargetClass())) {
                scope = (ScopeImpl)deq.pollLast();
            }
            if (scope != null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.selectors.isEmpty()) {
            return "SelectorMap{}";
        }
        return String.format("SelectorMap:{%n%s%n}", this.selectors.entrySet().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator())));
    }

    private static final class PredicateSelectorEntry<V> {
        private final PredicateSelectorImpl predicateSelector;
        private final V value;
        private boolean matched;

        private PredicateSelectorEntry(PredicateSelectorImpl predicateSelector, V value) {
            this.predicateSelector = predicateSelector;
            this.value = value;
        }
    }
}

