/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.instancio.TargetSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.selectors.Flattener;

public final class SubtypeSelectorMap {
    private final Map<TargetSelector, Class<?>> subtypeSelectors;
    private final SelectorMap<Class<?>> selectorMap = new SelectorMap();

    public SubtypeSelectorMap(Map<TargetSelector, Class<?>> subtypeSelectors) {
        this.subtypeSelectors = Collections.unmodifiableMap(subtypeSelectors);
        this.putAdditional(subtypeSelectors);
    }

    Map<TargetSelector, Class<?>> getSubtypeSelectors() {
        return this.subtypeSelectors;
    }

    SelectorMap<Class<?>> getSelectorMap() {
        return this.selectorMap;
    }

    public Optional<Class<?>> getSubtype(Node node) {
        return this.selectorMap.getValue(node);
    }

    void putAll(Map<TargetSelector, Class<?>> subtypeMapping) {
        subtypeMapping.forEach(this.selectorMap::put);
    }

    private void putAdditional(Map<TargetSelector, Class<?>> subtypes) {
        subtypes.forEach((targetSelector, subtype) -> {
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(selector, (Class<?>)subtype);
            }
        });
    }
}

