/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.List;
import java.util.Optional;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.settings.Keys;
import org.instancio.spi.GeneratorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorProviderFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorProviderFacade.class);
    private final GeneratorContext context;
    private final List<GeneratorProvider> generatorProviders;

    GeneratorProviderFacade(GeneratorContext context, List<GeneratorProvider> generatorProviders) {
        this.context = context;
        this.generatorProviders = generatorProviders;
    }

    Optional<Generator<?>> getGenerator(Class<?> forClass) {
        for (GeneratorProvider provider : this.generatorProviders) {
            Generator<?> generator = provider.getGenerators(this.context).get(forClass);
            if (generator == null) continue;
            LOG.trace("Custom generator '{}' found for {}", (Object)generator.getClass().getName(), forClass);
            Generator<?> decorated = GeneratorDecorator.decorate(generator, (AfterGenerate)((Object)this.context.getSettings().get(Keys.AFTER_GENERATE_HINT)));
            return Optional.of(decorated);
        }
        return Optional.empty();
    }
}

