/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.GeneratorProviderFacade;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.io.FileGenerator;
import org.instancio.internal.generator.lang.BooleanGenerator;
import org.instancio.internal.generator.lang.ByteGenerator;
import org.instancio.internal.generator.lang.CharacterGenerator;
import org.instancio.internal.generator.lang.DoubleGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.generator.lang.FloatGenerator;
import org.instancio.internal.generator.lang.IntegerGenerator;
import org.instancio.internal.generator.lang.LongGenerator;
import org.instancio.internal.generator.lang.ShortGenerator;
import org.instancio.internal.generator.lang.StringBuilderGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.generator.math.BigDecimalGenerator;
import org.instancio.internal.generator.math.BigIntegerGenerator;
import org.instancio.internal.generator.net.URIGenerator;
import org.instancio.internal.generator.net.URLGenerator;
import org.instancio.internal.generator.nio.file.PathGenerator;
import org.instancio.internal.generator.time.DurationGenerator;
import org.instancio.internal.generator.time.InstantGenerator;
import org.instancio.internal.generator.time.LocalDateGenerator;
import org.instancio.internal.generator.time.LocalDateTimeGenerator;
import org.instancio.internal.generator.time.LocalTimeGenerator;
import org.instancio.internal.generator.time.MonthDayGenerator;
import org.instancio.internal.generator.time.OffsetDateTimeGenerator;
import org.instancio.internal.generator.time.OffsetTimeGenerator;
import org.instancio.internal.generator.time.PeriodGenerator;
import org.instancio.internal.generator.time.YearGenerator;
import org.instancio.internal.generator.time.YearMonthGenerator;
import org.instancio.internal.generator.time.ZoneIdGenerator;
import org.instancio.internal.generator.time.ZoneOffsetGenerator;
import org.instancio.internal.generator.time.ZonedDateTimeGenerator;
import org.instancio.internal.generator.util.CalendarGenerator;
import org.instancio.internal.generator.util.CollectionGenerator;
import org.instancio.internal.generator.util.DateGenerator;
import org.instancio.internal.generator.util.EnumSetGenerator;
import org.instancio.internal.generator.util.LocaleGenerator;
import org.instancio.internal.generator.util.MapGenerator;
import org.instancio.internal.generator.util.OptionalGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.internal.generator.util.concurrent.atomic.AtomicIntegerGenerator;
import org.instancio.internal.generator.util.concurrent.atomic.AtomicLongGenerator;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.spi.GeneratorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorResolver.class);
    private static final List<GeneratorProvider> PROVIDERS = ServiceLoaders.loadAll(GeneratorProvider.class);
    private final Map<Class<?>, Generator<?>> generators = new HashMap();
    private final GeneratorContext context;
    private final GeneratorProviderFacade generatorProviderFacade;

    public GeneratorResolver(GeneratorContext context) {
        this.context = context;
        this.generatorProviderFacade = new GeneratorProviderFacade(context, PROVIDERS);
        this.initGeneratorMap();
    }

    private void initGeneratorMap() {
        this.generators.put(Byte.TYPE, new ByteGenerator(this.context));
        this.generators.put(Short.TYPE, new ShortGenerator(this.context));
        this.generators.put(Integer.TYPE, new IntegerGenerator(this.context));
        this.generators.put(Long.TYPE, new LongGenerator(this.context));
        this.generators.put(Float.TYPE, new FloatGenerator(this.context));
        this.generators.put(Double.TYPE, new DoubleGenerator(this.context));
        this.generators.put(Boolean.TYPE, new BooleanGenerator(this.context));
        this.generators.put(Character.TYPE, new CharacterGenerator(this.context));
        this.generators.put(Byte.class, new ByteGenerator(this.context));
        this.generators.put(Short.class, new ShortGenerator(this.context));
        this.generators.put(Integer.class, new IntegerGenerator(this.context));
        this.generators.put(Long.class, new LongGenerator(this.context));
        this.generators.put(Float.class, new FloatGenerator(this.context));
        this.generators.put(Double.class, new DoubleGenerator(this.context));
        this.generators.put(Boolean.class, new BooleanGenerator(this.context));
        this.generators.put(Character.class, new CharacterGenerator(this.context));
        this.generators.put(String.class, new StringGenerator(this.context));
        this.generators.put(Number.class, new IntegerGenerator(this.context));
        this.generators.put(CharSequence.class, new StringGenerator(this.context));
        this.generators.put(StringBuilder.class, new StringBuilderGenerator(this.context));
        this.generators.put(BigDecimal.class, new BigDecimalGenerator(this.context));
        this.generators.put(BigInteger.class, new BigIntegerGenerator(this.context));
        this.generators.put(URI.class, new URIGenerator(this.context));
        this.generators.put(URL.class, new URLGenerator(this.context));
        this.generators.put(File.class, new FileGenerator(this.context, new String[0]));
        this.generators.put(Path.class, new PathGenerator(this.context, new String[0]));
        this.generators.put(Instant.class, new InstantGenerator(this.context));
        this.generators.put(LocalDate.class, new LocalDateGenerator(this.context));
        this.generators.put(LocalDateTime.class, new LocalDateTimeGenerator(this.context));
        this.generators.put(LocalTime.class, new LocalTimeGenerator(this.context));
        this.generators.put(Duration.class, new DurationGenerator(this.context));
        this.generators.put(MonthDay.class, new MonthDayGenerator(this.context));
        this.generators.put(OffsetTime.class, new OffsetTimeGenerator(this.context));
        this.generators.put(OffsetDateTime.class, new OffsetDateTimeGenerator(this.context));
        this.generators.put(Period.class, new PeriodGenerator(this.context));
        this.generators.put(Temporal.class, new LocalDateGenerator(this.context));
        this.generators.put(Year.class, new YearGenerator(this.context));
        this.generators.put(YearMonth.class, new YearMonthGenerator(this.context));
        this.generators.put(ZonedDateTime.class, new ZonedDateTimeGenerator(this.context));
        this.generators.put(ZoneId.class, new ZoneIdGenerator(this.context));
        this.generators.put(ZoneOffset.class, new ZoneOffsetGenerator(this.context));
        this.generators.put(Calendar.class, new CalendarGenerator(this.context));
        this.generators.put(Date.class, new DateGenerator(this.context));
        this.generators.put(Locale.class, new LocaleGenerator(this.context));
        this.generators.put(Optional.class, new OptionalGenerator(this.context));
        this.generators.put(UUID.class, new UUIDGenerator(this.context));
        this.generators.put(Collection.class, new CollectionGenerator(this.context));
        this.generators.put(EnumSet.class, new EnumSetGenerator(this.context));
        this.generators.put(Iterable.class, new CollectionGenerator(this.context));
        this.generators.put(List.class, new CollectionGenerator(this.context));
        this.generators.put(Map.class, new MapGenerator(this.context));
        this.mapCollection(BlockingDeque.class, LinkedBlockingDeque.class);
        this.mapCollection(BlockingQueue.class, LinkedBlockingQueue.class);
        this.mapCollection(Deque.class, ArrayDeque.class);
        this.mapCollection(NavigableSet.class, TreeSet.class);
        this.mapCollection(Set.class, HashSet.class);
        this.mapCollection(SortedSet.class, TreeSet.class);
        this.mapCollection(TransferQueue.class, LinkedTransferQueue.class);
        this.mapCollection(Queue.class, ArrayDeque.class);
        this.mapMap(ConcurrentMap.class, ConcurrentHashMap.class);
        this.mapMap(ConcurrentNavigableMap.class, ConcurrentSkipListMap.class);
        this.mapMap(EnumMap.class, HashMap.class);
        this.mapMap(NavigableMap.class, TreeMap.class);
        this.mapMap(SortedMap.class, TreeMap.class);
        this.generators.put(AtomicInteger.class, new AtomicIntegerGenerator(this.context));
        this.generators.put(AtomicLong.class, new AtomicLongGenerator(this.context));
        GeneratorResolver.mapByClassName(this.context, this.generators, "java.sql.Date", "org.instancio.internal.generator.sql.SqlDateGenerator");
        GeneratorResolver.mapByClassName(this.context, this.generators, "java.sql.Timestamp", "org.instancio.internal.generator.sql.TimestampGenerator");
        GeneratorResolver.mapByClassName(this.context, this.generators, "javax.xml.datatype.XMLGregorianCalendar", "org.instancio.internal.generator.xml.XMLGregorianCalendarGenerator");
    }

    private void mapCollection(Class<?> type, Class<?> subtype) {
        CollectionGenerator generator = new CollectionGenerator(this.context);
        generator.subtype(subtype);
        this.generators.put(type, generator);
    }

    private void mapMap(Class<?> type, Class<?> subtype) {
        MapGenerator generator = new MapGenerator(this.context);
        generator.subtype(subtype);
        this.generators.put(type, generator);
    }

    private static void mapByClassName(GeneratorContext context, Map<Class<?>, Generator<?>> generators, String generateTypeClassName, String generatorClassName) {
        Class<?> targetClass = ReflectionUtils.loadClass(generateTypeClassName);
        Class<?> generatorClass = ReflectionUtils.loadClass(generatorClassName);
        if (targetClass == null || generatorClass == null) {
            return;
        }
        try {
            Constructor<?> constructor = generatorClass.getConstructor(GeneratorContext.class);
            Generator generator = (Generator)constructor.newInstance(context);
            generators.put(targetClass, generator);
        }
        catch (Exception ex) {
            LOG.trace("Failed loading generator class: '{}'", (Object)generatorClassName, (Object)ex);
        }
    }

    public Optional<Generator<?>> get(Class<?> klass) {
        Generator<?> generator = this.generatorProviderFacade.getGenerator(klass).orElse(this.generators.get(klass));
        if (generator == null) {
            if (klass.isArray()) {
                generator = new ArrayGenerator(this.context, klass);
            } else if (klass.isEnum()) {
                generator = new EnumGenerator(this.context, klass);
            }
        }
        return Optional.ofNullable(generator);
    }
}

