/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import org.instancio.documentation.InternalApi;
import org.instancio.generator.Hint;
import org.instancio.internal.generator.ContainerAddFunction;
import org.instancio.internal.generator.ContainerBuildFunction;
import org.instancio.internal.generator.ContainerCreateFunction;

@InternalApi
public final class InternalContainerHint
implements Hint<InternalContainerHint> {
    private static final InternalContainerHint EMPTY_HINT = InternalContainerHint.builder().build();
    private final ContainerCreateFunction<?> createFunction;
    private final ContainerAddFunction<?> addFunction;
    private final ContainerBuildFunction<?, ?> buildFunction;
    private final int generateEntries;

    public static InternalContainerHint empty() {
        return EMPTY_HINT;
    }

    public <C> ContainerCreateFunction<C> createFunction() {
        return this.createFunction;
    }

    public <C> ContainerAddFunction<C> addFunction() {
        return this.addFunction;
    }

    public <B, C> ContainerBuildFunction<B, C> buildFunction() {
        return this.buildFunction;
    }

    public int generateEntries() {
        return this.generateEntries;
    }

    private InternalContainerHint(Builder builder) {
        this.createFunction = builder.createFunction;
        this.addFunction = builder.addFunction;
        this.buildFunction = builder.buildFunction;
        this.generateEntries = builder.generateEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ContainerCreateFunction<?> createFunction;
        private ContainerAddFunction<?> addFunction;
        private ContainerBuildFunction<?, ?> buildFunction;
        private int generateEntries;

        private Builder() {
        }

        public <C> Builder createFunction(ContainerCreateFunction<C> function) {
            this.createFunction = function;
            return this;
        }

        public <C> Builder addFunction(ContainerAddFunction<C> function) {
            this.addFunction = function;
            return this;
        }

        public <B, C> Builder buildFunction(ContainerBuildFunction<B, C> function) {
            this.buildFunction = function;
            return this;
        }

        public Builder generateEntries(int generateEntries) {
            this.generateEntries = generateEntries;
            return this;
        }

        public InternalContainerHint build() {
            return new InternalContainerHint(this);
        }
    }
}

