/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.ArrayHint;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;

public class ArrayGenerator<T>
extends AbstractGenerator<T>
implements ArrayGeneratorSpec<T> {
    protected int minLength;
    protected int maxLength;
    private boolean nullable;
    private boolean nullableElements;
    private Class<?> arrayType;
    private List<Object> withElements;

    public ArrayGenerator(GeneratorContext context) {
        super(context);
        this.minLength = (Integer)context.getSettings().get(Keys.ARRAY_MIN_LENGTH);
        this.maxLength = (Integer)context.getSettings().get(Keys.ARRAY_MAX_LENGTH);
        this.nullable = (Boolean)context.getSettings().get(Keys.ARRAY_NULLABLE);
        this.nullableElements = (Boolean)context.getSettings().get(Keys.ARRAY_ELEMENTS_NULLABLE);
    }

    @Override
    public String apiMethod() {
        return "array()";
    }

    public ArrayGenerator(GeneratorContext context, Class<?> arrayType) {
        this(context);
        this.arrayType = ApiValidator.notNull(arrayType, "Type must not be null", new Object[0]);
    }

    @Override
    public ArrayGeneratorSpec<T> minLength(int length) {
        this.minLength = ApiValidator.validateLength(length);
        this.maxLength = NumberUtils.calculateNewMax(this.maxLength, this.minLength, 50);
        return this;
    }

    @Override
    public ArrayGeneratorSpec<T> maxLength(int length) {
        this.maxLength = ApiValidator.validateLength(length);
        this.minLength = NumberUtils.calculateNewMin(this.minLength, this.maxLength, 50);
        return this;
    }

    @Override
    public ArrayGeneratorSpec<T> length(int length) {
        this.maxLength = ApiValidator.validateLength(length);
        this.minLength = length;
        return this;
    }

    @Override
    public ArrayGeneratorSpec<T> nullable() {
        this.nullable = true;
        return this;
    }

    @Override
    public ArrayGeneratorSpec<T> nullableElements() {
        this.nullableElements = true;
        return this;
    }

    @Override
    public ArrayGenerator<T> subtype(Class<?> type) {
        ApiValidator.isTrue(type != null && type.isArray(), "Type must be an array: %s", type);
        this.arrayType = type;
        return this;
    }

    @Override
    @SafeVarargs
    public final ArrayGeneratorSpec<T> with(T ... elements) {
        ApiValidator.notEmpty(elements, "'array().with(...)' must contain at least one element", new Object[0]);
        if (this.withElements == null) {
            this.withElements = new ArrayList<Object>();
        }
        Collections.addAll(this.withElements, elements);
        return this;
    }

    @Override
    public T generate(Random random) {
        ApiValidator.isTrue(this.arrayType.isArray(), "Expected an array type: %s", this.arrayType);
        if (random.diceRoll(this.nullable)) {
            return null;
        }
        int length = random.intRange(this.minLength, this.maxLength) + (this.withElements == null ? 0 : this.withElements.size());
        return (T)Array.newInstance(this.arrayType.getComponentType(), length);
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).with(ArrayHint.builder().nullableElements(this.nullableElements).withElements(this.withElements).shuffle(!CollectionUtils.isNullOrEmpty(this.withElements)).build()).with(InternalGeneratorHint.builder().targetClass(this.arrayType).build()).build();
    }
}

