/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.BooleanAsStringGeneratorSpec;
import org.instancio.generator.specs.BooleanSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.settings.Keys;

public class BooleanGenerator
extends AbstractGenerator<Boolean>
implements BooleanSpec,
BooleanAsStringGeneratorSpec {
    private boolean nullable;

    public BooleanGenerator() {
        this(Global.generatorContext());
    }

    public BooleanGenerator(GeneratorContext context) {
        super(context);
        this.nullable = (Boolean)context.getSettings().get(Keys.BOOLEAN_NULLABLE);
    }

    @Override
    public String apiMethod() {
        return "booleans()";
    }

    @Override
    public BooleanGenerator nullable() {
        this.nullable = true;
        return this;
    }

    @Override
    public Boolean generate(Random random) {
        return random.diceRoll(this.nullable) ? null : Boolean.valueOf(random.trueOrFalse());
    }
}

