/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.CharacterAsStringGeneratorSpec;
import org.instancio.generator.specs.CharacterSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.settings.Keys;

public class CharacterGenerator
extends AbstractGenerator<Character>
implements CharacterSpec,
CharacterAsStringGeneratorSpec {
    private boolean nullable;

    public CharacterGenerator(GeneratorContext context) {
        super(context);
        this.nullable = (Boolean)context.getSettings().get(Keys.CHARACTER_NULLABLE);
    }

    public CharacterGenerator() {
        this(Global.generatorContext());
    }

    @Override
    public String apiMethod() {
        return "chars()";
    }

    @Override
    public CharacterGenerator nullable() {
        this.nullable = true;
        return this;
    }

    @Override
    public Character generate(Random random) {
        return random.diceRoll(this.nullable) ? null : Character.valueOf(random.upperCaseCharacter());
    }
}

