/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.DoubleSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;
import org.instancio.settings.Keys;

public class DoubleGenerator
extends AbstractRandomComparableNumberGeneratorSpec<Double>
implements DoubleSpec {
    public DoubleGenerator() {
        this(Global.generatorContext());
    }

    public DoubleGenerator(GeneratorContext context) {
        super(context, (Double)context.getSettings().get(Keys.DOUBLE_MIN), (Double)context.getSettings().get(Keys.DOUBLE_MAX), (Boolean)context.getSettings().get(Keys.DOUBLE_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "doubles()";
    }

    @Override
    public DoubleGenerator min(Double min) {
        super.min(min);
        return this;
    }

    @Override
    public DoubleGenerator max(Double max) {
        super.max(max);
        return this;
    }

    @Override
    public DoubleGenerator range(Double min, Double max) {
        super.range(min, max);
        return this;
    }

    @Override
    public DoubleGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Double generateNonNullValue(Random random) {
        return random.doubleRange((Double)this.getMin(), (Double)this.getMax());
    }
}

