/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.FloatSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;
import org.instancio.settings.Keys;

public class FloatGenerator
extends AbstractRandomComparableNumberGeneratorSpec<Float>
implements FloatSpec {
    public FloatGenerator() {
        this(Global.generatorContext());
    }

    public FloatGenerator(GeneratorContext context) {
        super(context, (Float)context.getSettings().get(Keys.FLOAT_MIN), (Float)context.getSettings().get(Keys.FLOAT_MAX), (Boolean)context.getSettings().get(Keys.FLOAT_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "floats()";
    }

    @Override
    public FloatGenerator min(Float min) {
        super.min(min);
        return this;
    }

    @Override
    public FloatGenerator max(Float max) {
        super.max(max);
        return this;
    }

    @Override
    public FloatGenerator range(Float min, Float max) {
        super.range(min, max);
        return this;
    }

    @Override
    public FloatGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Float generateNonNullValue(Random random) {
        return Float.valueOf(random.floatRange(((Float)this.getMin()).floatValue(), ((Float)this.getMax()).floatValue()));
    }
}

