/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.StringSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public class StringGenerator
extends AbstractGenerator<String>
implements StringSpec {
    protected int minLength;
    protected int maxLength;
    private boolean nullable;
    private boolean allowEmpty;
    private String prefix;
    private StringType stringType;

    public StringGenerator() {
        this(Global.generatorContext());
    }

    public StringGenerator(GeneratorContext context) {
        super(context);
        Settings settings = context.getSettings();
        this.minLength = (Integer)settings.get(Keys.STRING_MIN_LENGTH);
        this.maxLength = (Integer)settings.get(Keys.STRING_MAX_LENGTH);
        this.nullable = (Boolean)settings.get(Keys.STRING_NULLABLE);
        this.allowEmpty = (Boolean)settings.get(Keys.STRING_ALLOW_EMPTY);
    }

    @Override
    public String apiMethod() {
        return "string()";
    }

    @Override
    public StringGenerator prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public StringGenerator allowEmpty() {
        this.allowEmpty = true;
        return this;
    }

    @Override
    public StringGenerator nullable() {
        this.nullable = true;
        return this;
    }

    @Override
    public StringGenerator length(int length) {
        this.minLength = ApiValidator.validateLength(length);
        this.maxLength = length;
        return this;
    }

    @Override
    public StringGenerator length(int minLength, int maxLength) {
        this.minLength = ApiValidator.validateLength(minLength);
        this.maxLength = ApiValidator.validateLength(maxLength);
        ApiValidator.isTrue(minLength < maxLength, "Min length must be less than max (%s, %s)", minLength, maxLength);
        return this;
    }

    @Override
    public StringGenerator minLength(int length) {
        this.minLength = ApiValidator.validateLength(length);
        this.maxLength = NumberUtils.calculateNewMax(this.maxLength, this.minLength, 50);
        return this;
    }

    @Override
    public StringGenerator maxLength(int length) {
        this.maxLength = ApiValidator.validateLength(length);
        this.minLength = NumberUtils.calculateNewMin(this.minLength, this.maxLength, 50);
        return this;
    }

    @Override
    public StringGenerator lowerCase() {
        this.stringType = StringType.LOWER_CASE;
        return this;
    }

    @Override
    public StringGenerator upperCase() {
        this.stringType = StringType.UPPER_CASE;
        return this;
    }

    @Override
    public StringGenerator mixedCase() {
        this.stringType = StringType.MIXED_CASE;
        return this;
    }

    @Override
    public StringGenerator alphaNumeric() {
        this.stringType = StringType.ALPHANUMERIC;
        return this;
    }

    @Override
    public StringGenerator digits() {
        this.stringType = StringType.DIGITS;
        return this;
    }

    @Override
    public String generate(Random random) {
        if (random.diceRoll(this.nullable)) {
            return null;
        }
        if (random.diceRoll(this.allowEmpty)) {
            return "";
        }
        int length = random.intRange(this.minLength, this.maxLength);
        String result = this.generateString(random, length);
        return this.prefix == null ? result : this.prefix + result;
    }

    private String generateString(Random random, int length) {
        if (this.stringType == null || this.stringType == StringType.UPPER_CASE) {
            return random.upperCaseAlphabetic(length);
        }
        if (this.stringType == StringType.LOWER_CASE) {
            return random.lowerCaseAlphabetic(length);
        }
        if (this.stringType == StringType.MIXED_CASE) {
            return random.mixedCaseAlphabetic(length);
        }
        if (this.stringType == StringType.ALPHANUMERIC) {
            return random.alphanumeric(length);
        }
        if (this.stringType == StringType.DIGITS) {
            return random.digits(length);
        }
        throw new IllegalStateException("Unknown StringType: " + (Object)((Object)this.stringType));
    }

    private static enum StringType {
        LOWER_CASE,
        UPPER_CASE,
        MIXED_CASE,
        ALPHANUMERIC,
        DIGITS;

    }
}

