/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.sql;

import java.sql.Date;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.LocalDateGenerator;

public class SqlDateGenerator
extends AbstractGenerator<Date>
implements TemporalGeneratorSpec<Date> {
    private final LocalDateGenerator delegate;

    public SqlDateGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new LocalDateGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "sqlDate()";
    }

    @Override
    public TemporalGeneratorSpec<Date> past() {
        this.delegate.past();
        return this;
    }

    @Override
    public TemporalGeneratorSpec<Date> future() {
        this.delegate.future();
        return this;
    }

    @Override
    public TemporalGeneratorSpec<Date> range(Date start, Date end) {
        this.delegate.range(start.toLocalDate(), end.toLocalDate());
        return this;
    }

    @Override
    public Date generate(Random random) {
        return Date.valueOf(this.delegate.generate(random));
    }
}

