/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import org.instancio.Random;
import org.instancio.exception.InstancioApiException;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.ValueSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.AbstractGenerator;

public class TextPatternGenerator
extends AbstractGenerator<String>
implements ValueSpec<String> {
    private static final String ALLOWED_HASHTAGS_MESSAGE = String.format("%nAllowed hashtags:%n\t#a - alphanumeric character [a-z, A-Z, 0-9]%n\t#c - lower case character [a-z]%n\t#C - upper case character [A-Z]%n\t#d - digit [0-9]%n\t## - hash symbol escape%n", new Object[0]);
    private static final char ALNUM_CHAR = 'a';
    private static final char LCASE_CHAR = 'c';
    private static final char UCASE_CHAR = 'C';
    private static final char DIGIT = 'd';
    private static final char HASH = '#';
    private final String pattern;

    public TextPatternGenerator(String pattern) {
        this(Global.generatorContext(), pattern);
    }

    public TextPatternGenerator(GeneratorContext context, String pattern) {
        super(context);
        this.pattern = ApiValidator.notNull(pattern, "Text pattern must not be null", new Object[0]);
    }

    @Override
    public String apiMethod() {
        return "pattern()";
    }

    @Override
    public String generate(Random random) {
        StringBuilder res = new StringBuilder(this.pattern.length());
        char[] p = this.pattern.toCharArray();
        int i = 0;
        while (i < p.length) {
            char c;
            if ((c = p[i++]) == '#') {
                ApiValidator.isFalse(i == p.length, "Invalid text pattern '%s'. Expected a character after the last '#'", this.pattern);
                char tag = p[i++];
                if (tag == 'a') {
                    res.append(random.alphanumericCharacter());
                    continue;
                }
                if (tag == 'c') {
                    res.append(random.lowerCaseCharacter());
                    continue;
                }
                if (tag == 'C') {
                    res.append(random.upperCaseCharacter());
                    continue;
                }
                if (tag == 'd') {
                    res.append(random.digits(1));
                    continue;
                }
                if (tag == '#') {
                    res.append('#');
                    continue;
                }
                throw new InstancioApiException("Text pattern '" + this.pattern + "' contains an invalid hashtag '#" + tag + "'" + ALLOWED_HASHTAGS_MESSAGE);
            }
            res.append(c);
        }
        return res.toString();
    }
}

