/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.DurationGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

public class DurationGenerator
extends AbstractGenerator<Duration>
implements DurationGeneratorSpec {
    private static final long DEFAULT_MIN_AMOUNT = 1L;
    private static final long DEFAULT_MAX_AMOUNT = 1000000000000000L;
    private static final TemporalUnit DEFAULT_UNIT = ChronoUnit.NANOS;
    private long minAmount = 1L;
    private long maxAmount = 1000000000000000L;
    private TemporalUnit unit = DEFAULT_UNIT;
    private boolean allowZero;

    public DurationGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "duration()";
    }

    @Override
    public DurationGeneratorSpec of(long minAmount, long maxAmount, TemporalUnit unit) {
        ApiValidator.notNull(unit, "Unit must not be null", new Object[0]);
        ApiValidator.isTrue(minAmount <= maxAmount, "Minimum duration amount must be less than or equal to the maximum amount: of(%s, %s, %s)", minAmount, maxAmount, unit);
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.unit = unit;
        return this;
    }

    @Override
    public DurationGeneratorSpec allowZero() {
        this.allowZero = true;
        return this;
    }

    @Override
    public Duration generate(Random random) {
        return random.diceRoll(this.allowZero) ? Duration.ZERO : Duration.of(random.longRange(this.minAmount, this.maxAmount), this.unit);
    }
}

