/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.LocalTime;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.LocalTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;

public class LocalTimeGenerator
extends JavaTimeTemporalGenerator<LocalTime>
implements LocalTimeSpec {
    public LocalTimeGenerator() {
        this(Global.generatorContext());
    }

    public LocalTimeGenerator(GeneratorContext context) {
        super(context, LocalTime.of(0, 0, 0), LocalTime.of(23, 59, 59));
    }

    @Override
    public String apiMethod() {
        return "localTime()";
    }

    @Override
    public LocalTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public LocalTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public LocalTimeGenerator range(LocalTime start, LocalTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    LocalTime getLatestPast() {
        return LocalTime.now().minusSeconds(1L);
    }

    @Override
    LocalTime getEarliestFuture() {
        return LocalTime.now().plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((LocalTime)this.min).compareTo((LocalTime)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public LocalTime generate(Random random) {
        return LocalTime.ofNanoOfDay(random.longRange(((LocalTime)this.min).toNanoOfDay(), ((LocalTime)this.max).toNanoOfDay()));
    }
}

