/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.OffsetDateTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.generator.time.LocalDateTimeGenerator;
import org.instancio.internal.util.Constants;

public class OffsetDateTimeGenerator
extends JavaTimeTemporalGenerator<OffsetDateTime>
implements OffsetDateTimeSpec {
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private final LocalDateTimeGenerator delegate;

    public OffsetDateTimeGenerator() {
        this(Global.generatorContext());
    }

    public OffsetDateTimeGenerator(GeneratorContext context) {
        super(context, OffsetDateTime.ofInstant(Constants.DEFAULT_MIN, ZONE_ID), OffsetDateTime.ofInstant(Constants.DEFAULT_MAX, ZONE_ID));
        this.delegate = new LocalDateTimeGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "offsetDateTime()";
    }

    @Override
    public OffsetDateTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public OffsetDateTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public OffsetDateTimeGenerator range(OffsetDateTime start, OffsetDateTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    OffsetDateTime getLatestPast() {
        return OffsetDateTime.now().minusSeconds(1L);
    }

    @Override
    OffsetDateTime getEarliestFuture() {
        return OffsetDateTime.now().plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((OffsetDateTime)this.min).compareTo((OffsetDateTime)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public OffsetDateTime generate(Random random) {
        this.delegate.range(((OffsetDateTime)this.min).toLocalDateTime(), ((OffsetDateTime)this.max).toLocalDateTime());
        return OffsetDateTime.of(this.delegate.generate(random), ZoneOffset.UTC);
    }
}

