/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.OffsetTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;

public class OffsetTimeGenerator
extends JavaTimeTemporalGenerator<OffsetTime>
implements OffsetTimeSpec {
    private static final int MAX_NANO = 999999999;
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.UTC;

    public OffsetTimeGenerator() {
        this(Global.generatorContext());
    }

    public OffsetTimeGenerator(GeneratorContext context) {
        super(context, OffsetTime.of(0, 0, 0, 0, ZONE_OFFSET), OffsetTime.of(23, 59, 59, 999999999, ZONE_OFFSET));
    }

    @Override
    public String apiMethod() {
        return "offsetTime()";
    }

    @Override
    public OffsetTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public OffsetTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public OffsetTimeGenerator range(OffsetTime start, OffsetTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    OffsetTime getLatestPast() {
        return OffsetTime.now(ZONE_OFFSET).minusSeconds(1L);
    }

    @Override
    OffsetTime getEarliestFuture() {
        return OffsetTime.now(ZONE_OFFSET).plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((OffsetTime)this.min).compareTo((OffsetTime)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public OffsetTime generate(Random random) {
        int hour = random.intRange(((OffsetTime)this.min).getHour(), ((OffsetTime)this.max).getHour());
        int minute = random.intRange(((OffsetTime)this.min).getMinute(), ((OffsetTime)this.max).getMinute());
        int second = random.intRange(((OffsetTime)this.min).getSecond(), ((OffsetTime)this.max).getSecond());
        int nano = random.intRange(((OffsetTime)this.min).getNano(), ((OffsetTime)this.max).getNano());
        return OffsetTime.of(hour, minute, second, nano, ZONE_OFFSET);
    }
}

