/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Year;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.YearSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;

public class YearGenerator
extends JavaTimeTemporalGenerator<Year>
implements YearSpec {
    public YearGenerator() {
        this(Global.generatorContext());
    }

    public YearGenerator(GeneratorContext context) {
        super(context, Year.of(1970), Year.now().plusYears(50L));
    }

    @Override
    public String apiMethod() {
        return "year()";
    }

    @Override
    public YearGenerator past() {
        super.past();
        return this;
    }

    @Override
    public YearGenerator future() {
        super.future();
        return this;
    }

    @Override
    public YearGenerator range(Year start, Year end) {
        super.range(start, end);
        return this;
    }

    @Override
    Year getLatestPast() {
        return Year.now().minusYears(1L);
    }

    @Override
    Year getEarliestFuture() {
        return Year.now().plusYears(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((Year)this.min).compareTo((Year)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public Year generate(Random random) {
        return Year.of(random.intRange(((Year)this.min).getValue(), ((Year)this.max).getValue()));
    }
}

