/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.YearMonth;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.YearMonthSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;

public class YearMonthGenerator
extends JavaTimeTemporalGenerator<YearMonth>
implements YearMonthSpec {
    public YearMonthGenerator() {
        this(Global.generatorContext());
    }

    public YearMonthGenerator(GeneratorContext context) {
        super(context, YearMonth.of(1970, 1), YearMonth.now().plusYears(50L));
    }

    @Override
    public String apiMethod() {
        return "yearMonth()";
    }

    @Override
    public YearMonthGenerator past() {
        super.past();
        return this;
    }

    @Override
    public YearMonthGenerator future() {
        super.future();
        return this;
    }

    @Override
    public YearMonthGenerator range(YearMonth start, YearMonth end) {
        super.range(start, end);
        return this;
    }

    @Override
    YearMonth getLatestPast() {
        return YearMonth.now().minusMonths(1L);
    }

    @Override
    YearMonth getEarliestFuture() {
        return YearMonth.now().plusMonths(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((YearMonth)this.min).compareTo((YearMonth)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public YearMonth generate(Random random) {
        int minMonth = ((YearMonth)this.min).getYear() * 12 + ((YearMonth)this.min).getMonthValue() - 1;
        int maxMonth = ((YearMonth)this.max).getYear() * 12 + ((YearMonth)this.max).getMonthValue() - 1;
        int result = random.intRange(minMonth, maxMonth);
        int year = result / 12;
        int month = result - year * 12 + 1;
        return YearMonth.of(year, month);
    }
}

