/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.ZonedDateTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.InstantGenerator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;

public class ZonedDateTimeGenerator
extends JavaTimeTemporalGenerator<ZonedDateTime>
implements ZonedDateTimeSpec {
    private final InstantGenerator delegate;

    public ZonedDateTimeGenerator() {
        this(Global.generatorContext());
    }

    public ZonedDateTimeGenerator(GeneratorContext context) {
        super(context, ZonedDateTime.ofInstant(Constants.DEFAULT_MIN, Constants.ZONE_OFFSET), ZonedDateTime.ofInstant(Constants.DEFAULT_MAX, Constants.ZONE_OFFSET));
        this.delegate = new InstantGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "zonedDateTime()";
    }

    @Override
    public ZonedDateTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public ZonedDateTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public ZonedDateTimeGenerator range(ZonedDateTime start, ZonedDateTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    ZonedDateTime getLatestPast() {
        return ZonedDateTime.now(Constants.ZONE_OFFSET).minusSeconds(1L);
    }

    @Override
    ZonedDateTime getEarliestFuture() {
        return ZonedDateTime.now(Constants.ZONE_OFFSET).plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((ZonedDateTime)this.min).compareTo((ChronoZonedDateTime)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public ZonedDateTime generate(Random random) {
        this.delegate.range(((ZonedDateTime)this.min).toInstant(), ((ZonedDateTime)this.max).toInstant());
        return ZonedDateTime.ofInstant(this.delegate.generate(random), Constants.ZONE_OFFSET);
    }
}

