/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.ZonedDateTimeGenerator;

public class CalendarGenerator
extends AbstractGenerator<Calendar>
implements TemporalGeneratorSpec<Calendar> {
    private final ZonedDateTimeGenerator delegate;

    public CalendarGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new ZonedDateTimeGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "calendar()";
    }

    @Override
    public TemporalGeneratorSpec<Calendar> past() {
        this.delegate.past();
        return this;
    }

    @Override
    public TemporalGeneratorSpec<Calendar> future() {
        this.delegate.future();
        return this;
    }

    @Override
    public TemporalGeneratorSpec<Calendar> range(Calendar start, Calendar end) {
        this.delegate.range(ZonedDateTime.ofInstant(start.toInstant(), start.getTimeZone().toZoneId()), ZonedDateTime.ofInstant(end.toInstant(), end.getTimeZone().toZoneId()));
        return this;
    }

    @Override
    public Calendar generate(Random random) {
        return GregorianCalendar.from(this.delegate.generate(random));
    }
}

