/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.nodes.Node;
import org.jetbrains.annotations.NotNull;

public class ArrayNodeHandler
implements NodeHandler {
    private final GeneratorResolver generatorResolver;
    private final ModelContext<?> context;

    public ArrayNodeHandler(ModelContext<?> context, GeneratorResolver generatorResolver) {
        this.context = context;
        this.generatorResolver = generatorResolver;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull Node node) {
        if (node.getTargetClass().isArray()) {
            Generator<?> generator = this.generatorResolver.get(node.getTargetClass()).orElseThrow(() -> new IllegalStateException("Unable to get array generator for node: " + node));
            Object arrayObject = generator.generate(this.context.getRandom());
            return GeneratorResult.create(arrayObject, generator.hints());
        }
        return GeneratorResult.emptyResult();
    }
}

