/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.util.Collection;
import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.CollectionHint;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.reflection.instantiation.Instantiator;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;

public class CollectionNodeHandler
implements NodeHandler {
    private final ModelContext<?> context;
    private final Instantiator instantiator;

    public CollectionNodeHandler(ModelContext<?> context, Instantiator instantiator) {
        this.context = context;
        this.instantiator = instantiator;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull Node node) {
        if (Collection.class.isAssignableFrom(node.getTargetClass())) {
            Hints hints = Hints.builder().with(CollectionHint.builder().generateElements(this.randomSize()).build()).afterGenerate(AfterGenerate.POPULATE_ALL).build();
            Object collection = this.instantiator.instantiate(node.getTargetClass());
            return GeneratorResult.create(collection, hints);
        }
        return GeneratorResult.emptyResult();
    }

    private int randomSize() {
        Random random = this.context.getRandom();
        Settings settings = this.context.getSettings();
        return random.intRange((Integer)settings.get(Keys.COLLECTION_MIN_SIZE), (Integer)settings.get(Keys.COLLECTION_MAX_SIZE));
    }
}

