/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.nodes.TypeResolverFacade;
import org.instancio.internal.nodes.resolvers.NodeKindArrayResolver;
import org.instancio.internal.nodes.resolvers.NodeKindCollectionResolver;
import org.instancio.internal.nodes.resolvers.NodeKindContainerResolver;
import org.instancio.internal.nodes.resolvers.NodeKindMapResolver;
import org.instancio.internal.nodes.resolvers.NodeKindRecordResolver;
import org.instancio.internal.spi.InternalContainerFactoryProvider;

public final class NodeContext {
    private final Map<TypeVariable<?>, Class<?>> rootTypeMap;
    private final SubtypeSelectorMap subtypeSelectorMap;
    private final Map<Class<?>, Class<?>> subtypeMappingFromSettings;
    private final TypeResolverFacade typeResolverFacade;
    private final List<NodeKindResolver> nodeKindResolvers;

    private NodeContext(Builder builder) {
        this.rootTypeMap = builder.rootTypeMap;
        this.subtypeSelectorMap = builder.subtypeSelectorMap;
        this.subtypeMappingFromSettings = builder.subtypeMappingFromSettings;
        this.typeResolverFacade = new TypeResolverFacade();
        this.nodeKindResolvers = Arrays.asList(new NodeKindCollectionResolver(), new NodeKindMapResolver(), new NodeKindArrayResolver(), new NodeKindRecordResolver(), new NodeKindContainerResolver(Collections.unmodifiableList(builder.containerFactories)));
    }

    public List<NodeKindResolver> getNodeKindResolvers() {
        return this.nodeKindResolvers;
    }

    public Map<TypeVariable<?>, Class<?>> getRootTypeMap() {
        return this.rootTypeMap;
    }

    Optional<Class<?>> getSubtype(Node node) {
        Optional<Class<?>> subtype = this.subtypeSelectorMap.getSubtype(node);
        if (subtype.isPresent()) {
            return subtype;
        }
        Class<?> subtypeFromSettings = this.subtypeMappingFromSettings.get(node.getRawType());
        return subtypeFromSettings == null ? this.typeResolverFacade.resolve(node.getRawType()) : Optional.of(subtypeFromSettings);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<TypeVariable<?>, Class<?>> rootTypeMap = Collections.emptyMap();
        private SubtypeSelectorMap subtypeSelectorMap;
        private Map<Class<?>, Class<?>> subtypeMappingFromSettings = Collections.emptyMap();
        private List<InternalContainerFactoryProvider> containerFactories = Collections.emptyList();

        private Builder() {
        }

        public Builder rootTypeMap(Map<TypeVariable<?>, Class<?>> rootTypeMap) {
            this.rootTypeMap = rootTypeMap;
            return this;
        }

        public Builder subtypeSelectorMap(SubtypeSelectorMap subtypeSelectorMap) {
            this.subtypeSelectorMap = subtypeSelectorMap;
            return this;
        }

        public Builder subtypeMappingFromSettings(Map<Class<?>, Class<?>> subtypeMappingFromSettings) {
            this.subtypeMappingFromSettings = subtypeMappingFromSettings;
            return this;
        }

        public Builder containerFactories(List<InternalContainerFactoryProvider> containerFactories) {
            this.containerFactories = containerFactories;
            return this;
        }

        public NodeContext build() {
            return new NodeContext(this);
        }
    }
}

