/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes.resolvers;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.spi.InternalContainerFactoryProvider;

public class NodeKindContainerResolver
implements NodeKindResolver {
    private final List<InternalContainerFactoryProvider> containerFactories;

    public NodeKindContainerResolver(List<InternalContainerFactoryProvider> containerFactories) {
        this.containerFactories = containerFactories;
    }

    @Override
    public Optional<NodeKind> resolve(Class<?> targetClass) {
        if (targetClass == Optional.class || targetClass == EnumSet.class || this.containerFactories.stream().anyMatch(p -> p.isContainerClass(targetClass))) {
            return Optional.of(NodeKind.CONTAINER);
        }
        return Optional.empty();
    }
}

