/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.random;

import java.util.Collection;
import org.instancio.Random;
import org.instancio.internal.random.RandomDataGenerator;
import org.instancio.internal.random.Seeds;
import org.instancio.internal.util.Verify;

public class DefaultRandom
implements Random {
    private final long seed;
    private final java.util.Random random;

    public DefaultRandom() {
        this(Seeds.randomSeed());
    }

    public DefaultRandom(long seed) {
        this.seed = seed;
        this.random = new java.util.Random(seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean trueOrFalse() {
        return this.intRange(0, 1) == 1;
    }

    @Override
    public boolean diceRoll(boolean precondition) {
        return precondition && this.intRange(0, 5) == 1;
    }

    @Override
    public byte byteRange(byte min, byte max) {
        return (byte)this.longRange(min, max);
    }

    @Override
    public short shortRange(short min, short max) {
        return (short)this.longRange(min, max);
    }

    @Override
    public int intRange(int min, int max) {
        return (int)this.longRange(min, max);
    }

    @Override
    public long longRange(long min, long max) {
        return RandomDataGenerator.nextLong(this.random, min, max);
    }

    @Override
    public float floatRange(float min, float max) {
        return (float)this.doubleRange(min, max);
    }

    @Override
    public double doubleRange(double min, double max) {
        return RandomDataGenerator.nextDouble(this.random, min, max);
    }

    @Override
    public char character() {
        return this.trueOrFalse() ? this.lowerCaseCharacter() : this.upperCaseCharacter();
    }

    @Override
    public char lowerCaseCharacter() {
        return (char)(this.intRange(0, 25) + 97);
    }

    @Override
    public char upperCaseCharacter() {
        return (char)(this.intRange(0, 25) + 65);
    }

    @Override
    public char alphanumericCharacter() {
        return this.intRange(0, 2) == 1 ? this.digitChar() : this.character();
    }

    private char digitChar() {
        return (char)(this.intRange(0, 9) + 48);
    }

    @Override
    public String lowerCaseAlphabetic(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.lowerCaseCharacter();
        }
        return new String(s);
    }

    @Override
    public String upperCaseAlphabetic(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.upperCaseCharacter();
        }
        return new String(s);
    }

    @Override
    public String digits(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.digitChar();
        }
        return new String(s);
    }

    @Override
    public String alphanumeric(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.alphanumericCharacter();
        }
        return new String(s);
    }

    @Override
    public String mixedCaseAlphabetic(int length) {
        char[] s = new char[length];
        for (int i = 0; i < length; ++i) {
            s[i] = this.character();
        }
        return new String(s);
    }

    @Override
    public <T> T oneOf(T[] array) {
        Verify.notEmpty(array, "Array must have at least one element", new Object[0]);
        return array[this.intRange(0, array.length - 1)];
    }

    @Override
    public <T> T oneOf(Collection<T> collection) {
        Verify.notEmpty(collection, "Collection must have at least one element", new Object[0]);
        return collection.stream().skip(this.intRange(0, collection.size() - 1)).findFirst().orElse(null);
    }
}

