/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.instancio.internal.reflection.DefaultPackageFilter;
import org.instancio.internal.reflection.FieldCollector;
import org.instancio.internal.reflection.PackageFilter;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public class DeclaredAndInheritedFieldsCollector
implements FieldCollector {
    private final PackageFilter packageFilter = new DefaultPackageFilter();

    @Override
    public List<Field> getFields(Class<?> klass) {
        Class<?> next = Verify.notNull(klass, "Class is null", new Object[0]);
        ArrayList<Field> collected = new ArrayList<Field>();
        while (this.shouldCollectFrom(next)) {
            for (Field field : next.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                collected.add(field);
            }
            next = next.getSuperclass();
        }
        return collected;
    }

    private boolean shouldCollectFrom(@Nullable Class<?> c) {
        return c != null && !c.isInterface() && !c.isArray() && c != Object.class && !this.packageFilter.isExcluded(c.getPackage());
    }
}

