/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.Selector;
import org.instancio.TargetSelector;
import org.instancio.internal.selectors.Flattener;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Format;
import org.jetbrains.annotations.Nullable;

public class SelectorImpl
implements Selector,
GroupableSelector,
Flattener,
UnusedSelectorDescription {
    private static final SelectorImpl ROOT = new SelectorImpl((Class)Root.class, null){

        @Override
        public String toString() {
            return "root()";
        }
    };
    private final Class<?> targetClass;
    private final String fieldName;
    private final List<Scope> scopes;
    private final Selector parent;
    private final Throwable stackTraceHolder;

    private SelectorImpl(@Nullable Class<?> targetClass, @Nullable String fieldName, @Nullable List<Scope> scopes, @Nullable Selector parent, @Nullable Throwable stackTraceHolder) {
        this.targetClass = targetClass;
        this.fieldName = fieldName;
        this.scopes = scopes == null ? Collections.emptyList() : Collections.unmodifiableList(scopes);
        this.parent = parent;
        this.stackTraceHolder = stackTraceHolder;
    }

    SelectorImpl(@Nullable Class<?> targetClass, @Nullable String fieldName) {
        this(targetClass, fieldName, Collections.emptyList(), null, new Throwable());
    }

    private SelectorImpl(Builder builder) {
        this.targetClass = builder.targetClass;
        this.fieldName = builder.fieldName;
        this.scopes = builder.scopes == null ? Collections.emptyList() : Collections.unmodifiableList(builder.scopes);
        this.parent = builder.parent;
        this.stackTraceHolder = builder.stackTraceHolder == null ? new Throwable() : builder.stackTraceHolder;
    }

    public static Builder builder(SelectorImpl copy) {
        Builder builder = new Builder();
        builder.targetClass = copy.getTargetClass();
        builder.fieldName = copy.getFieldName();
        builder.scopes = copy.getScopes();
        builder.parent = copy.getParent();
        builder.stackTraceHolder = copy.getStackTraceHolder();
        return builder;
    }

    public static SelectorImpl getRootSelector() {
        return ROOT;
    }

    public Throwable getStackTraceHolder() {
        return this.stackTraceHolder;
    }

    @Override
    public String getDescription() {
        return String.format("%s%n    at %s", this, Format.firstNonInstancioStackTraceLine(this.stackTraceHolder));
    }

    @Override
    public Selector within(Scope ... scopes) {
        return SelectorImpl.builder(this).scopes(Arrays.asList(scopes)).build();
    }

    @Override
    public Scope toScope() {
        return new ScopeImpl(this.targetClass, this.fieldName);
    }

    @Override
    public List<TargetSelector> flatten() {
        return Collections.singletonList(this);
    }

    public Selector getParent() {
        return this.parent;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public boolean isFieldSelector() {
        return this.fieldName != null;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorImpl)) {
            return false;
        }
        SelectorImpl that = (SelectorImpl)o;
        return Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.scopes, that.scopes);
    }

    public final int hashCode() {
        return Objects.hash(this.targetClass, this.fieldName, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parent instanceof PrimitiveAndWrapperSelectorImpl) {
            sb.append(this.parent);
        } else {
            sb.append(this.isFieldSelector() ? "field(" : "all(");
            if (this.targetClass != null) {
                sb.append(this.targetClass.getSimpleName());
            }
            if (this.fieldName != null) {
                if (this.targetClass != null) {
                    sb.append(", ");
                }
                sb.append('\"').append(this.fieldName).append('\"');
            }
            sb.append(')');
            if (!this.scopes.isEmpty()) {
                sb.append(", ").append(Format.formatScopes(this.scopes));
            }
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Class<?> targetClass;
        private String fieldName;
        private List<Scope> scopes;
        private Selector parent;
        private Throwable stackTraceHolder;

        private Builder() {
        }

        public Builder targetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder scopes(List<Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder parent(Selector parent) {
            this.parent = parent;
            return this;
        }

        public Builder stackTraceHolder(Throwable stackTraceHolder) {
            this.stackTraceHolder = stackTraceHolder;
            return this;
        }

        public SelectorImpl build() {
            return new SelectorImpl(this);
        }
    }

    private static final class Root
    extends Enum<Root> {
        private static final /* synthetic */ Root[] $VALUES;

        public static Root[] values() {
            return (Root[])$VALUES.clone();
        }

        public static Root valueOf(String name) {
            return Enum.valueOf(Root.class, name);
        }

        private static /* synthetic */ Root[] $values() {
            return new Root[0];
        }

        static {
            $VALUES = Root.$values();
        }
    }
}

