/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.instancio.Random;
import org.jetbrains.annotations.Nullable;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... values) {
        return values == null ? Collections.emptyList() : Arrays.asList(values);
    }

    @SafeVarargs
    public static <T> List<T> combine(List<T> list, T ... values) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.addAll(result, values);
        return Collections.unmodifiableList(result);
    }

    public static void shuffle(Collection<Object> collection, Random random) {
        if (collection.isEmpty()) {
            return;
        }
        if (collection instanceof List) {
            CollectionUtils.shuffleList((List)collection, random);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(collection);
        CollectionUtils.shuffleList(list, random);
        collection.clear();
        collection.addAll(list);
    }

    private static void shuffleList(List<Object> list, Random random) {
        for (int i = 0; i < list.size(); ++i) {
            int r = random.intRange(0, i);
            Object tmp = list.get(i);
            list.set(i, list.get(r));
            list.set(r, tmp);
        }
    }
}

