/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class NumberUtils {
    private static final Map<Class<?>, Number> NUMERIC_MIN_VALUES = new HashMap();
    private static final Map<Class<?>, Number> NUMERIC_MAX_VALUES = new HashMap();
    private static final Map<Class<?>, Function<Long, Number>> CONVERT_TO_LONG_FN_MAP = new HashMap();

    public static <T extends Number> T getMinValue(Class<?> klass) {
        return (T)NUMERIC_MIN_VALUES.get(klass);
    }

    public static <T extends Number> T getMaxValue(Class<?> klass) {
        return (T)NUMERIC_MAX_VALUES.get(klass);
    }

    public static <T extends Number> Function<Long, T> getToLongConverter(Class<?> klass) {
        return CONVERT_TO_LONG_FN_MAP.get(klass);
    }

    public static <T extends Number> T calculateNewMin(@Nullable T curMin, T newMax, int percentage) {
        long newMin;
        if (curMin == null || ((Comparable)((Object)curMin)).compareTo(newMax) > 0) {
            long delta = (long)Math.abs((double)newMax.longValue() * ((double)percentage / 100.0));
            T absoluteMin = NumberUtils.getMinValue(newMax.getClass());
            newMin = ((Number)absoluteMin).longValue() + delta <= newMax.longValue() ? newMax.longValue() - delta : ((Number)absoluteMin).longValue();
        } else {
            newMin = curMin.longValue();
        }
        Function<Long, Long> fn = NumberUtils.getToLongConverter(newMax.getClass());
        return (T)((Number)fn.apply(newMin));
    }

    public static <T extends Number> T calculateNewMax(@Nullable T curMax, T newMin, int percentage) {
        long newMax;
        if (curMax == null || ((Comparable)((Object)curMax)).compareTo(newMin) < 0) {
            long delta = (long)Math.abs((double)newMin.longValue() * ((double)percentage / 100.0));
            T absoluteMax = NumberUtils.getMaxValue(newMin.getClass());
            newMax = ((Number)absoluteMax).longValue() - delta >= newMin.longValue() ? newMin.longValue() + delta : ((Number)absoluteMax).longValue();
        } else {
            newMax = curMax.longValue();
        }
        Function<Long, Long> fn = NumberUtils.getToLongConverter(newMin.getClass());
        return (T)((Number)fn.apply(newMax));
    }

    private NumberUtils() {
    }

    static {
        NUMERIC_MIN_VALUES.put(Byte.class, (byte)-128);
        NUMERIC_MIN_VALUES.put(Short.class, (short)Short.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Integer.class, Integer.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Long.class, Long.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(Float.class, Float.valueOf(Float.MIN_VALUE));
        NUMERIC_MIN_VALUES.put(Double.class, Double.MIN_VALUE);
        NUMERIC_MIN_VALUES.put(BigInteger.class, BigInteger.valueOf(Long.MIN_VALUE));
        NUMERIC_MIN_VALUES.put(BigDecimal.class, new BigDecimal(Long.MIN_VALUE));
        NUMERIC_MAX_VALUES.put(Byte.class, (byte)127);
        NUMERIC_MAX_VALUES.put(Short.class, (short)Short.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Integer.class, Integer.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Long.class, Long.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        NUMERIC_MAX_VALUES.put(Double.class, Double.MAX_VALUE);
        NUMERIC_MAX_VALUES.put(BigInteger.class, BigInteger.valueOf(Long.MAX_VALUE));
        NUMERIC_MAX_VALUES.put(BigDecimal.class, new BigDecimal(Long.MAX_VALUE));
        CONVERT_TO_LONG_FN_MAP.put(Byte.class, Long::byteValue);
        CONVERT_TO_LONG_FN_MAP.put(Short.class, Long::shortValue);
        CONVERT_TO_LONG_FN_MAP.put(Integer.class, Long::intValue);
        CONVERT_TO_LONG_FN_MAP.put(Long.class, l -> l);
        CONVERT_TO_LONG_FN_MAP.put(Float.class, Long::floatValue);
        CONVERT_TO_LONG_FN_MAP.put(Double.class, Long::doubleValue);
        CONVERT_TO_LONG_FN_MAP.put(BigDecimal.class, BigDecimal::new);
        CONVERT_TO_LONG_FN_MAP.put(BigInteger.class, BigInteger::valueOf);
    }
}

