/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.instancio.exception.InstancioException;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.ArrayHint;
import org.instancio.generator.hints.CollectionHint;
import org.instancio.generator.hints.MapHint;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.CallbackHandler;
import org.instancio.internal.ContainerFactoriesHandler;
import org.instancio.internal.DelayedNode;
import org.instancio.internal.DelayedNodeQueue;
import org.instancio.internal.DelayedRecordComponentNode;
import org.instancio.internal.ErrorHandler;
import org.instancio.internal.GeneratedNullValueListener;
import org.instancio.internal.GeneratedObjectStore;
import org.instancio.internal.GenerationListener;
import org.instancio.internal.GeneratorFacade;
import org.instancio.internal.InternalModel;
import org.instancio.internal.InternalModelDump;
import org.instancio.internal.NodeFilter;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.AssignerImpl;
import org.instancio.internal.assignment.AssignmentErrorUtil;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.ContainerAddFunction;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalContainerHint;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ArrayUtils;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.RecordUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstancioEngine {
    private static final Logger LOG = LoggerFactory.getLogger(InstancioEngine.class);
    private final GeneratorFacade generatorFacade;
    private final ModelContext<?> context;
    private final InternalNode rootNode;
    private final ErrorHandler errorHandler;
    private final CallbackHandler callbackHandler;
    private final ContainerFactoriesHandler containerFactoriesHandler;
    private final GenerationListener[] listeners;
    private final AfterGenerate defaultAfterGenerate;
    private final NodeFilter nodeFilter;
    private final Assigner assigner;
    private final GeneratedObjectStore generatedObjectStore;
    private final DelayedNodeQueue delayedNodeQueue = new DelayedNodeQueue();

    InstancioEngine(InternalModel<?> model) {
        InternalModelDump.printVerbose(model);
        this.context = model.getModelContext();
        this.rootNode = model.getRootNode();
        this.errorHandler = new ErrorHandler(this.context);
        this.callbackHandler = new CallbackHandler(this.context);
        this.containerFactoriesHandler = new ContainerFactoriesHandler(this.context.getContainerFactories());
        this.generatedObjectStore = new GeneratedObjectStore(this.context);
        this.generatorFacade = new GeneratorFacade(this.context, this.generatedObjectStore);
        this.defaultAfterGenerate = this.context.getSettings().get(Keys.AFTER_GENERATE_HINT);
        this.nodeFilter = new NodeFilter(this.context);
        this.assigner = new AssignerImpl(this.context);
        this.listeners = new GenerationListener[]{this.callbackHandler, this.generatedObjectStore, new GeneratedNullValueListener(this.context)};
    }

    <T> T createRootObject() {
        return this.errorHandler.conditionalFailOnError(this::createRootObjectInternal).orElse(null);
    }

    private Object createRootObjectInternal() {
        Class<?> rootClass;
        GeneratorResult generatorResult = this.createObject(this.rootNode);
        this.callbackHandler.invokeCallbacks();
        this.processDelayedNodes(true);
        this.context.reportWarnings();
        if (generatorResult.isEmpty() && Modifier.isAbstract((rootClass = this.rootNode.getTargetClass()).getModifiers()) && !this.context.getSubtypeSelectorMap().getSubtype(this.rootNode).isPresent()) {
            throw Fail.withUsageError(ErrorMessageUtils.abstractRootWithoutSubtype(rootClass), new Object[0]);
        }
        return generatorResult.getValue();
    }

    private void processDelayedNodes(boolean failOnUnprocessed) {
        int i = this.delayedNodeQueue.size();
        while (i >= 0 && !this.delayedNodeQueue.isEmpty()) {
            DelayedNode entry = this.delayedNodeQueue.removeFirst();
            GeneratorResult result = this.createObject(entry.getNode());
            if (result.isDelayed()) {
                --i;
                this.delayedNodeQueue.addLast(entry);
                continue;
            }
            this.assignFieldValue(entry.getParentResult().getValue(), entry.getNode(), result);
        }
        if (failOnUnprocessed && (this.delayedNodeQueue.hasRecordNodes() || !this.delayedNodeQueue.isEmpty())) {
            String msg = AssignmentErrorUtil.getUnresolvedAssignmentErrorMessage(this.generatorFacade.getUnresolvedAssignments(), this.delayedNodeQueue);
            throw Fail.withUnresolvedAssignment(msg, new Object[0]);
        }
    }

    @NotNull
    private GeneratorResult createObject(InternalNode node, boolean isNullable) {
        GeneratorResult generatorResult;
        LOG.trace(" >> {}", (Object)node);
        if (this.context.getRandom().diceRoll(isNullable)) {
            generatorResult = GeneratorResult.nullResult();
        } else if (node.is(NodeKind.JDK) || node.getChildren().isEmpty()) {
            generatorResult = this.generateValue(node);
        } else if (node.is(NodeKind.ARRAY)) {
            generatorResult = this.generateArray(node);
        } else if (node.is(NodeKind.COLLECTION)) {
            generatorResult = this.generateCollection(node);
        } else if (node.is(NodeKind.MAP)) {
            generatorResult = this.generateMap(node);
        } else if (node.is(NodeKind.RECORD)) {
            generatorResult = this.generateRecord(node);
        } else if (node.is(NodeKind.CONTAINER)) {
            generatorResult = this.generateContainer(node);
        } else if (node.is(NodeKind.POJO)) {
            generatorResult = this.generatePojo(node);
        } else {
            throw Fail.withFataInternalError("Unhandled node kind: '%s' for %s", new Object[]{node.getNodeKind(), node});
        }
        this.notifyListeners(node, generatorResult);
        if (this.generatedObjectStore.hasNewValues()) {
            this.processDelayedNodes(false);
        }
        LOG.trace("<< {} : {}", (Object)node, (Object)generatorResult);
        return generatorResult;
    }

    @NotNull
    private GeneratorResult createObject(InternalNode node) {
        return this.createObject(node, false);
    }

    private GeneratorResult generatePojo(InternalNode node) {
        GeneratorResult nodeResult = this.generateValue(node);
        if (!nodeResult.isDelayed()) {
            this.populateChildren(node.getChildren(), nodeResult);
        }
        return nodeResult;
    }

    private GeneratorResult generateMap(InternalNode node) {
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.containsNull() || node.getChildren().size() < 2) {
            return generatorResult;
        }
        ApiValidator.validateValueIsAssignableToTargetClass(generatorResult.getValue(), Map.class, node);
        Map map = (Map)generatorResult.getValue();
        InternalNode keyNode = node.getChildren().get(0);
        InternalNode valueNode = node.getChildren().get(1);
        Hints hints = generatorResult.getHints();
        for (Map.Entry entry : map.entrySet()) {
            List<InternalNode> keyNodeChildren = keyNode.getChildren();
            List<InternalNode> valueNodeChildren = valueNode.getChildren();
            this.populateChildren(keyNodeChildren, GeneratorResult.create(entry.getKey(), hints));
            this.populateChildren(valueNodeChildren, GeneratorResult.create(entry.getValue(), hints));
        }
        if (keyNode.isIgnored() || valueNode.isIgnored()) {
            return generatorResult;
        }
        MapHint hint = ObjectUtils.defaultIfNull(hints.get(MapHint.class), MapHint.empty());
        boolean nullableKey = hint.nullableMapKeys();
        boolean nullableValue = hint.nullableMapValues();
        Iterator withKeysIterator = hint.withKeys().iterator();
        int entriesToGenerate = hint.generateEntries();
        int failedAdditions = 0;
        while (entriesToGenerate > 0) {
            Object mapKey;
            this.generatedObjectStore.enterScope();
            GeneratorResult mapKeyResult = this.createObject(keyNode, nullableKey);
            GeneratorResult mapValueResult = this.createObject(valueNode, nullableValue);
            this.generatedObjectStore.exitScope();
            if (mapKeyResult.isDelayed() || mapValueResult.isDelayed()) {
                return GeneratorResult.delayed();
            }
            Object mapValue = mapValueResult.getValue();
            Object object = mapKey = withKeysIterator.hasNext() ? withKeysIterator.next() : mapKeyResult.getValue();
            if ((mapKey != null || nullableKey) && (mapValue != null || nullableValue || mapValueResult.hasEmitNullHint())) {
                if (!map.containsKey(mapKey)) {
                    ApiValidator.validateValueIsAssignableToElementNode("error adding key to map", mapKey, node, keyNode);
                    ApiValidator.validateValueIsAssignableToElementNode("error adding value to map", mapValue, node, valueNode);
                    map.put(mapKey, mapValue);
                    --entriesToGenerate;
                } else {
                    ++failedAdditions;
                }
            } else {
                ++failedAdditions;
            }
            if (failedAdditions <= 1000) continue;
            if (keyNode.isCyclic() || valueNode.isCyclic()) break;
            this.errorHandler.conditionalFailOnError(() -> {
                throw Fail.withInternalError(ErrorMessageUtils.mapCouldNotBePopulated(this.context, node, hint.generateEntries()), new Object[0]);
            });
            break;
        }
        if (!hint.withEntries().isEmpty()) {
            map.putAll(hint.withEntries());
        }
        return this.containerFactoriesHandler.substituteResult(node, generatorResult);
    }

    private GeneratorResult generateArray(InternalNode node) {
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.containsNull() || node.getChildren().isEmpty()) {
            return generatorResult;
        }
        Object arrayObj = generatorResult.getValue();
        Hints hints = generatorResult.getHints();
        ArrayHint hint = ObjectUtils.defaultIfNull(hints.get(ArrayHint.class), ArrayHint.empty());
        List withElements = hint.withElements();
        int arrayLength = Array.getLength(arrayObj);
        InternalNode elementNode = node.getOnlyChild();
        int lastIndex = 0;
        int j = 0;
        for (int i = 0; i < arrayLength && j < withElements.size(); ++i) {
            Object elementValue = Array.get(arrayObj, i);
            if (elementValue != null) {
                List<InternalNode> elementNodeChildren = node.getOnlyChild().getChildren();
                this.populateChildren(elementNodeChildren, GeneratorResult.create(elementValue, hints));
            }
            if (!ReflectionUtils.neitherNullNorPrimitiveWithDefaultValue(elementNode.getRawType(), elementValue)) {
                Array.set(arrayObj, i, withElements.get(j));
                ++j;
            }
            lastIndex = i + 1;
        }
        AfterGenerate action = hints.afterGenerate();
        boolean isPrimitiveArray = elementNode.getRawType().isPrimitive();
        int failedAdditions = 0;
        for (int i = lastIndex; i < arrayLength; ++i) {
            Object currentValue = Array.get(arrayObj, i);
            if (currentValue != null) {
                List<InternalNode> elementNodeChildren = node.getOnlyChild().getChildren();
                this.populateChildren(elementNodeChildren, GeneratorResult.create(currentValue, hints));
            }
            if (this.nodeFilter.shouldSkip(elementNode, action, currentValue)) continue;
            this.generatedObjectStore.enterScope();
            GeneratorResult elementResult = this.createObject(elementNode, hint.nullableElements());
            this.generatedObjectStore.exitScope();
            if (elementResult.isDelayed()) {
                return GeneratorResult.delayed();
            }
            Object elementValue = elementResult.getValue();
            while (!(elementValue != null || hint.nullableElements() || elementResult.hasEmitNullHint() || this.context.isIgnored(elementNode) || failedAdditions >= 1000)) {
                ++failedAdditions;
                elementValue = this.createObject(elementNode, false).getValue();
            }
            if (isPrimitiveArray && elementValue == null) continue;
            ApiValidator.validateValueIsAssignableToElementNode("array element type mismatch", elementValue, node, elementNode);
            Array.set(arrayObj, i, elementValue);
        }
        if (hint.shuffle()) {
            ArrayUtils.shuffle(arrayObj, this.context.getRandom());
        }
        return generatorResult;
    }

    private GeneratorResult generateCollection(InternalNode node) {
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.containsNull() || node.getChildren().isEmpty()) {
            return generatorResult;
        }
        ApiValidator.validateValueIsAssignableToTargetClass(generatorResult.getValue(), Collection.class, node);
        Collection collection = (Collection)generatorResult.getValue();
        InternalNode elementNode = node.getOnlyChild();
        Hints hints = generatorResult.getHints();
        for (Object element : collection) {
            List<InternalNode> elementNodeChildren = elementNode.getChildren();
            this.populateChildren(elementNodeChildren, GeneratorResult.create(element, hints));
        }
        if (elementNode.isIgnored()) {
            return generatorResult;
        }
        CollectionHint hint = ObjectUtils.defaultIfNull(hints.get(CollectionHint.class), CollectionHint.empty());
        boolean nullableElements = hint.nullableElements();
        boolean requireUnique = hint.unique();
        HashSet<Object> generated = new HashSet<Object>();
        int elementsToGenerate = hint.generateElements();
        int failedAdditions = 0;
        while (elementsToGenerate > 0) {
            this.generatedObjectStore.enterScope();
            GeneratorResult elementResult = this.createObject(elementNode, nullableElements);
            this.generatedObjectStore.exitScope();
            if (elementResult.isDelayed()) {
                return GeneratorResult.delayed();
            }
            Object elementValue = elementResult.getValue();
            if (elementValue != null || nullableElements || elementResult.hasEmitNullHint()) {
                boolean canAdd;
                boolean bl = canAdd = !requireUnique || !generated.contains(elementValue);
                if (requireUnique) {
                    generated.add(elementValue);
                }
                if (canAdd && collection.add(elementValue)) {
                    ApiValidator.validateValueIsAssignableToElementNode("error adding element to collection", elementValue, node, elementNode);
                    --elementsToGenerate;
                } else {
                    ++failedAdditions;
                }
            } else {
                ++failedAdditions;
            }
            if (failedAdditions <= 1000) continue;
            if (elementNode.isCyclic()) break;
            this.errorHandler.conditionalFailOnError(() -> {
                throw Fail.withInternalError(ErrorMessageUtils.collectionCouldNotBePopulated(this.context, node, hint.generateElements()), new Object[0]);
            });
            break;
        }
        if (!hint.withElements().isEmpty()) {
            collection.addAll(hint.withElements());
        }
        if (hint.shuffle()) {
            CollectionUtils.shuffle(collection, this.context.getRandom());
        }
        return this.containerFactoriesHandler.substituteResult(node, generatorResult);
    }

    private GeneratorResult generateRecord(InternalNode node) {
        GeneratorResult result;
        GeneratorResult customRecord = this.generateValue(node);
        if (!customRecord.isEmpty()) {
            return customRecord;
        }
        List<InternalNode> children = node.getChildren();
        Object[] args = new Object[children.size()];
        Class<?>[] ctorArgs = RecordUtils.getComponentTypes(node.getTargetClass());
        if (ctorArgs.length != args.length) {
            LOG.debug("Record {} has {} constructor arguments, but got {}", new Object[]{node.getTargetClass(), ctorArgs.length, args.length});
            return GeneratorResult.nullResult();
        }
        ArrayDeque<DelayedRecordComponentNode> recordComponentQueue = new ArrayDeque<DelayedRecordComponentNode>();
        for (int i = 0; i < args.length; ++i) {
            InternalNode child = children.get(i);
            result = this.createObject(child);
            if (result.isDelayed()) {
                LOG.trace("Delayed record arg: {}", (Object)child);
                recordComponentQueue.add(new DelayedRecordComponentNode(child, i));
                continue;
            }
            args[i] = result.containsNull() ? ObjectUtils.defaultValue(ctorArgs[i]) : result.getValue();
        }
        int threshold = recordComponentQueue.size();
        while (!recordComponentQueue.isEmpty()) {
            DelayedRecordComponentNode entry = (DelayedRecordComponentNode)recordComponentQueue.removeLast();
            result = this.createObject(entry.getNode());
            LOG.trace("Attempt to create delayed record component: {}", (Object)entry.getNode());
            if (result.isDelayed()) {
                --threshold;
                recordComponentQueue.addFirst(entry);
            } else if (!result.isEmpty() && !result.isIgnored()) {
                args[entry.getArgIndex()] = result.getValue();
            }
            if (threshold != 0) continue;
            break;
        }
        if (!recordComponentQueue.isEmpty()) {
            this.delayedNodeQueue.addRecord(node);
            return GeneratorResult.delayed();
        }
        try {
            Object obj = RecordUtils.instantiate(node.getTargetClass(), args);
            GeneratorResult generatorResult = GeneratorResult.create(obj, Hints.afterGenerate(this.defaultAfterGenerate));
            this.delayedNodeQueue.removeRecord(node);
            return generatorResult;
        }
        catch (Exception ex) {
            this.errorHandler.conditionalFailOnError(() -> {
                throw new InstancioException("Failed creating a record for: " + node, ex);
            });
            return GeneratorResult.emptyResult();
        }
    }

    private void populateChildren(List<InternalNode> children, GeneratorResult generatorResult) {
        if (generatorResult.containsNull()) {
            return;
        }
        Object value = generatorResult.getValue();
        AfterGenerate action = generatorResult.getHints().afterGenerate();
        for (InternalNode child : children) {
            if (this.nodeFilter.shouldSkip(child, action, value)) continue;
            GeneratorResult result = this.createObject(child);
            if (result.isDelayed()) {
                this.delayedNodeQueue.addLast(new DelayedNode(child, generatorResult));
                continue;
            }
            this.assignFieldValue(value, child, result);
        }
    }

    private GeneratorResult generateContainer(InternalNode node) {
        ContainerAddFunction addFunction;
        GeneratorResult generatorResult = this.generateValue(node);
        if (generatorResult.isEmpty() || generatorResult.isIgnored()) {
            return generatorResult;
        }
        InternalContainerHint hint = ObjectUtils.defaultIfNull(generatorResult.getHints().get(InternalContainerHint.class), InternalContainerHint.empty());
        List<InternalNode> children = node.getChildren();
        if (generatorResult.containsNull() && hint.createFunction() != null) {
            Object[] args = new Object[children.size()];
            for (int i = 0; i < children.size(); ++i) {
                InternalNode childNode = children.get(i);
                GeneratorResult childResult = this.createObject(childNode);
                if (childResult.isDelayed()) {
                    return GeneratorResult.delayed();
                }
                ApiValidator.validateValueIsAssignableToElementNode("error populating object due to incompatible types", childResult.getValue(), node, childNode);
                args[i] = childResult.getValue();
            }
            Object result = hint.createFunction().create(args);
            generatorResult = GeneratorResult.create(result, generatorResult.getHints());
        }
        if ((addFunction = hint.addFunction()) != null) {
            for (int i = 0; i < hint.generateEntries(); ++i) {
                Object[] args = new Object[children.size()];
                this.generatedObjectStore.enterScope();
                for (int j = 0; j < children.size(); ++j) {
                    GeneratorResult childResult = this.createObject(children.get(j));
                    args[j] = childResult.getValue();
                }
                this.generatedObjectStore.exitScope();
                addFunction.addTo(generatorResult.getValue(), args);
            }
        }
        if (hint.buildFunction() != null) {
            Object builtContainer = hint.buildFunction().build(generatorResult.getValue());
            return GeneratorResult.create(builtContainer, generatorResult.getHints());
        }
        return this.containerFactoriesHandler.substituteResult(node, generatorResult);
    }

    private void assignFieldValue(Object parentResult, InternalNode node, GeneratorResult result) {
        if (!result.isEmpty() && !result.isIgnored()) {
            this.assigner.assign(node, parentResult, result.getValue());
        }
    }

    private GeneratorResult generateValue(InternalNode node) {
        return this.generatorFacade.generateNodeValue(node);
    }

    private void notifyListeners(InternalNode node, GeneratorResult result) {
        if (!(result.isEmpty() || result.isDelayed() || result.isIgnored())) {
            for (GenerationListener listener : this.listeners) {
                listener.objectCreated(node, result);
            }
        }
    }
}

