/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.CommonBeanValidationHandlerMap;

final class JavaxBeanValidationHandlerMap
extends CommonBeanValidationHandlerMap {
    JavaxBeanValidationHandlerMap() {
        this.put(() -> AssertFalse.class, new CommonBeanValidationHandlerMap.AssertBooleanHandler(false));
        this.put(() -> AssertTrue.class, new CommonBeanValidationHandlerMap.AssertBooleanHandler(true));
        this.put(() -> DecimalMax.class, new DecimalMaxHandler());
        this.put(() -> DecimalMin.class, new DecimalMinHandler());
        this.put(() -> Digits.class, new DigitsHandler());
        this.put(() -> Future.class, new CommonBeanValidationHandlerMap.FutureHandler());
        this.put(() -> FutureOrPresent.class, new CommonBeanValidationHandlerMap.FutureHandler());
        this.put(() -> Max.class, new MaxHandler());
        this.put(() -> Min.class, new MinHandler());
        this.put(() -> Negative.class, new CommonBeanValidationHandlerMap.NegativeHandler(new BigDecimal("-0.5")));
        this.put(() -> NotBlank.class, new CommonBeanValidationHandlerMap.NotEmptyHandler());
        this.put(() -> NotEmpty.class, new CommonBeanValidationHandlerMap.NotEmptyHandler());
        this.put(() -> NotNull.class, new CommonBeanValidationHandlerMap.NotNullHandler());
        this.put(() -> NegativeOrZero.class, new CommonBeanValidationHandlerMap.NegativeHandler(BigDecimal.ZERO));
        this.put(() -> Past.class, new CommonBeanValidationHandlerMap.PastHandler());
        this.put(() -> PastOrPresent.class, new CommonBeanValidationHandlerMap.PastHandler());
        this.put(() -> Positive.class, new CommonBeanValidationHandlerMap.PositiveHandler(new BigDecimal("0.5")));
        this.put(() -> PositiveOrZero.class, new CommonBeanValidationHandlerMap.PositiveHandler(BigDecimal.ZERO));
        this.put(() -> Size.class, new SizeHandler());
    }

    static AnnotationHandlerMap getInstance() {
        return Holder.INSTANCE;
    }

    private static final class DecimalMaxHandler
    extends CommonBeanValidationHandlerMap.AbstractDecimalMaxHandler {
        private DecimalMaxHandler() {
        }

        @Override
        String getValue(Annotation annotation) {
            return ((DecimalMax)annotation).value();
        }
    }

    private static final class DecimalMinHandler
    extends CommonBeanValidationHandlerMap.AbstractDecimalMinHandler {
        private DecimalMinHandler() {
        }

        @Override
        String getValue(Annotation annotation) {
            return ((DecimalMin)annotation).value();
        }
    }

    private static final class DigitsHandler
    extends CommonBeanValidationHandlerMap.AbstractDigitsHandler {
        private DigitsHandler() {
        }

        @Override
        int getFraction(Annotation annotation) {
            return ((Digits)annotation).fraction();
        }

        @Override
        int getInteger(Annotation annotation) {
            return ((Digits)annotation).integer();
        }
    }

    private static final class MaxHandler
    extends CommonBeanValidationHandlerMap.AbstractMaxHandler {
        private MaxHandler() {
        }

        @Override
        long getValue(Annotation annotation) {
            return ((Max)annotation).value();
        }
    }

    private static final class MinHandler
    extends CommonBeanValidationHandlerMap.AbstractMinHandler {
        private MinHandler() {
        }

        @Override
        long getValue(Annotation annotation) {
            return ((Min)annotation).value();
        }
    }

    private static final class SizeHandler
    extends CommonBeanValidationHandlerMap.AbstractSizeHandler {
        private SizeHandler() {
        }

        @Override
        int getMin(Annotation annotation) {
            return ((Size)annotation).min();
        }

        @Override
        int getMax(Annotation annotation) {
            return ((Size)annotation).max();
        }
    }

    private static final class Holder {
        private static final AnnotationHandlerMap INSTANCE = new JavaxBeanValidationHandlerMap();

        private Holder() {
        }
    }
}

