/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.Assignment;
import org.instancio.TargetSelector;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.Flattener;
import org.instancio.internal.assignment.GeneratorHolder;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.context.TargetSelectorSelectorMap;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

public final class AssignmentSelectorMap {
    private final GeneratorContext context;
    private final AfterGenerate defaultAfterGenerate;
    private final Map<TargetSelector, List<Assignment>> assignmentSelectors;
    private final SelectorMap<List<InternalAssignment>> selectorMap;
    private final BooleanSelectorMap originSelectors;
    private final TargetSelectorSelectorMap destinationSelectors;
    private final Map<TargetSelector, Class<?>> generatorSubtypeMap = new LinkedHashMap();

    public AssignmentSelectorMap(@NotNull Map<TargetSelector, List<Assignment>> targetSelectors, @NotNull GeneratorContext context) {
        this.context = context;
        this.defaultAfterGenerate = context.getSettings().get(Keys.AFTER_GENERATE_HINT);
        this.assignmentSelectors = Collections.unmodifiableMap(targetSelectors);
        this.selectorMap = targetSelectors.isEmpty() ? SelectorMapImpl.emptyMap() : new SelectorMapImpl();
        HashMap<TargetSelector, List<TargetSelector>> originDestinationsMap = new HashMap<TargetSelector, List<TargetSelector>>();
        for (Map.Entry<TargetSelector, List<Assignment>> entry : targetSelectors.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            List<InternalAssignment> assignments = this.processAssignments(entry.getValue());
            for (InternalAssignment a : assignments) {
                List destinations = originDestinationsMap.computeIfAbsent(a.getOrigin(), k -> new ArrayList());
                destinations.add(a.getDestination());
            }
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(selector, assignments);
            }
        }
        this.originSelectors = new BooleanSelectorMap(originDestinationsMap.keySet());
        this.destinationSelectors = new TargetSelectorSelectorMap(originDestinationsMap);
    }

    private List<InternalAssignment> processAssignments(List<Assignment> assignments) {
        ArrayList<InternalAssignment> processed = new ArrayList<InternalAssignment>(assignments.size());
        Generators generators = new Generators(this.context);
        for (Assignment c : assignments) {
            InternalAssignment assignment = (InternalAssignment)c;
            if (assignment.getGeneratorHolder() != null) {
                Generator generator = this.getGenerator(assignment, generators);
                InternalAssignment updated = assignment.toBuilder().generator(generator).build();
                processed.add(updated);
                continue;
            }
            processed.add(assignment);
        }
        return processed;
    }

    private <T> Generator<T> getGenerator(InternalAssignment assignment, Generators generators) {
        GeneratorHolder holder = assignment.getGeneratorHolder();
        Generator g = holder.getGenerator() == null ? (Generator)holder.getSpecProvider().getSpec(generators) : holder.getGenerator();
        g.init(this.context);
        Generator generator = GeneratorDecorator.decorateIfNullAfterGenerate(g, this.defaultAfterGenerate);
        InternalGeneratorHint internalHint = generator.hints().get(InternalGeneratorHint.class);
        Optional.ofNullable(internalHint).map(InternalGeneratorHint::targetClass).ifPresent(klass -> this.generatorSubtypeMap.put(assignment.getDestination(), (Class<?>)klass));
        return generator;
    }

    public List<InternalAssignment> getAssignments(InternalNode node) {
        Optional<List<InternalAssignment>> value = this.selectorMap.getValue(node);
        return value.orElse(Collections.emptyList());
    }

    BooleanSelectorMap getOriginSelectors() {
        return this.originSelectors;
    }

    SelectorMap<List<InternalAssignment>> getSelectorMap() {
        return this.selectorMap;
    }

    TargetSelectorSelectorMap getDestinationSelectors() {
        return this.destinationSelectors;
    }

    Map<TargetSelector, List<Assignment>> getAssignmentSelectors() {
        return this.assignmentSelectors;
    }

    List<TargetSelector> getDestinationSelectors(InternalNode node) {
        return this.destinationSelectors.getTargetSelector(node);
    }

    Map<TargetSelector, Class<?>> getGeneratorSubtypeMap() {
        return this.generatorSubtypeMap;
    }
}

