/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.instancio.TargetSelector;
import org.instancio.internal.Flattener;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

public final class SubtypeSelectorMap {
    private final Map<TargetSelector, Class<?>> subtypeSelectors;
    private final SelectorMap<Class<?>> selectorMap;

    public SubtypeSelectorMap(@NotNull Map<TargetSelector, Class<?>> subtypeSelectors, @NotNull Map<TargetSelector, Class<?>> generatorSubtypeMap, @NotNull Map<TargetSelector, Class<?>> assignmentGeneratorSubtypeMap) {
        this.subtypeSelectors = Collections.unmodifiableMap(subtypeSelectors);
        this.selectorMap = subtypeSelectors.isEmpty() && generatorSubtypeMap.isEmpty() && assignmentGeneratorSubtypeMap.isEmpty() ? SelectorMapImpl.emptyMap() : new SelectorMapImpl();
        this.putAll(subtypeSelectors);
        this.putAll(generatorSubtypeMap);
        this.putAll(assignmentGeneratorSubtypeMap);
    }

    private void putAll(Map<TargetSelector, Class<?>> subtypes) {
        subtypes.forEach((targetSelector, subtype) -> {
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(selector, (Class<?>)subtype);
            }
        });
    }

    Map<TargetSelector, Class<?>> getSubtypeSelectors() {
        return this.subtypeSelectors;
    }

    SelectorMap<Class<?>> getSelectorMap() {
        return this.selectorMap;
    }

    public Optional<Class<?>> getSubtype(InternalNode node) {
        return this.selectorMap.getValue(node);
    }
}

