/*
 * Decompiled with CFR 0.152.
 */
package org.instancio;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.instancio.InstancioApi;
import org.instancio.InstancioCartesianProductApi;
import org.instancio.InstancioClassApi;
import org.instancio.InstancioCollectionsApi;
import org.instancio.InstancioFeedApi;
import org.instancio.InstancioGenApi;
import org.instancio.Model;
import org.instancio.Select;
import org.instancio.TypeTokenSupplier;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.feed.Feed;
import org.instancio.internal.ApiImpl;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.CartesianProductApiImpl;
import org.instancio.internal.ClassApiImpl;
import org.instancio.internal.CollectionsApiImpl;
import org.instancio.internal.FeedApiImpl;
import org.instancio.internal.GenApiImpl;
import org.instancio.internal.MapApiImpl;
import org.instancio.internal.util.TypeUtils;

public final class Instancio {
    private Instancio() {
    }

    public static <T> T create(Class<T> type) {
        return Instancio.of(type).create();
    }

    @ExperimentalApi
    public static <T> T createBlank(Class<T> type) {
        return Instancio.ofBlank(type).create();
    }

    public static <T> List<T> createList(Class<T> elementType) {
        return (List)Instancio.ofList(elementType).create();
    }

    public static <T> Set<T> createSet(Class<T> elementType) {
        return (Set)Instancio.ofSet(elementType).create();
    }

    public static <K, V> Map<K, V> createMap(Class<K> keyType, Class<V> valueType) {
        return (Map)Instancio.ofMap(keyType, valueType).create();
    }

    public static <T> Stream<T> stream(Class<T> type) {
        return Instancio.of(type).stream();
    }

    public static <T> T create(TypeTokenSupplier<T> typeToken) {
        return Instancio.of(typeToken).create();
    }

    public static <T> Stream<T> stream(TypeTokenSupplier<T> typeToken) {
        return Instancio.of(typeToken).stream();
    }

    public static <T> T create(Model<T> model) {
        return Instancio.of(model).create();
    }

    public static <T> Stream<T> stream(Model<T> model) {
        return Instancio.of(model).stream();
    }

    public static <T> InstancioClassApi<T> of(Class<T> type) {
        return new ClassApiImpl(type);
    }

    @ExperimentalApi
    public static <T> InstancioClassApi<T> ofBlank(Class<T> type) {
        ClassApiImpl api = new ClassApiImpl(type);
        api.setBlank(Select.root());
        return api;
    }

    public static <T> InstancioApi<T> of(TypeTokenSupplier<T> typeToken) {
        return new ApiImpl<T>(typeToken);
    }

    public static <T> InstancioApi<T> of(Model<T> model) {
        return new ApiImpl<T>(model);
    }

    @ExperimentalApi
    public static <T> InstancioCartesianProductApi<T> ofCartesianProduct(Class<T> type) {
        return new CartesianProductApiImpl(ApiValidator.validateOfCartesianProductElementType(type));
    }

    @ExperimentalApi
    public static <T> InstancioCartesianProductApi<T> ofCartesianProduct(TypeTokenSupplier<T> typeToken) {
        return new CartesianProductApiImpl<T>(typeToken);
    }

    @ExperimentalApi
    public static <T> InstancioCartesianProductApi<T> ofCartesianProduct(Model<T> model) {
        return new CartesianProductApiImpl(model);
    }

    public static <T> InstancioCollectionsApi<List<T>> ofList(Class<T> elementType) {
        return new CollectionsApiImpl(List.class, ApiValidator.validateOfListElementType(elementType));
    }

    public static <T> InstancioCollectionsApi<List<T>> ofList(TypeTokenSupplier<T> elementTypeToken) {
        return new CollectionsApiImpl(List.class, ApiValidator.validateTypeToken(elementTypeToken));
    }

    public static <T> InstancioCollectionsApi<List<T>> ofList(Model<T> elementModel) {
        return CollectionsApiImpl.fromElementModel(TypeUtils.cast(List.class), elementModel);
    }

    public static <T> InstancioCollectionsApi<Set<T>> ofSet(Class<T> elementType) {
        return new CollectionsApiImpl(Set.class, ApiValidator.validateOfSetElementType(elementType));
    }

    public static <T> InstancioCollectionsApi<Set<T>> ofSet(TypeTokenSupplier<T> elementTypeToken) {
        return new CollectionsApiImpl(Set.class, ApiValidator.validateTypeToken(elementTypeToken));
    }

    public static <T> InstancioCollectionsApi<Set<T>> ofSet(Model<T> elementModel) {
        return CollectionsApiImpl.fromElementModel(TypeUtils.cast(Set.class), elementModel);
    }

    public static <K, V> InstancioCollectionsApi<Map<K, V>> ofMap(Class<K> keyType, Class<V> valueType) {
        return new MapApiImpl(Map.class, ApiValidator.validateOfMapKeyOrValueType(keyType), ApiValidator.validateOfMapKeyOrValueType(valueType));
    }

    public static <K, V> InstancioCollectionsApi<Map<K, V>> ofMap(TypeTokenSupplier<K> keyTypeToken, TypeTokenSupplier<V> valueTypeToken) {
        return new MapApiImpl(Map.class, ApiValidator.validateTypeToken(keyTypeToken), ApiValidator.validateTypeToken(valueTypeToken));
    }

    @ExperimentalApi
    public static InstancioGenApi gen() {
        return new GenApiImpl();
    }

    @ExperimentalApi
    public static <F extends Feed> F createFeed(Class<F> type) {
        return new FeedApiImpl<F>(type).create();
    }

    @ExperimentalApi
    public static <F extends Feed> InstancioFeedApi<F> ofFeed(Class<F> type) {
        return new FeedApiImpl<F>(type);
    }
}

