/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.instancio.internal.annotation.GetterMethodResolver;
import org.instancio.internal.annotation.GetterMethodResolverImpl;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.settings.BeanValidationTarget;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

public final class AnnotationExtractor {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final BeanValidationTarget beanValidationTarget;
    private final GetterMethodResolver getterMethodResolver;

    public AnnotationExtractor(ModelContext context) {
        this.beanValidationTarget = context.getSettings().get(Keys.BEAN_VALIDATION_TARGET);
        this.getterMethodResolver = new GetterMethodResolverImpl();
    }

    @NotNull
    public Annotation[] getAnnotations(InternalNode node) {
        Field field = node.getField();
        if (field == null) {
            return AnnotationExtractor.getTypeUseAnnotations(node);
        }
        if (this.beanValidationTarget == BeanValidationTarget.FIELD) {
            return field.getDeclaredAnnotations();
        }
        Method getter = this.getterMethodResolver.getGetter(node);
        return getter == null ? EMPTY_ANNOTATIONS : getter.getDeclaredAnnotations();
    }

    private static Annotation[] getTypeUseAnnotations(InternalNode node) {
        Field parentField;
        Field field = parentField = node.getParent() == null ? null : node.getParent().getField();
        if (parentField != null && parentField.getAnnotatedType() instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType apt = (AnnotatedParameterizedType)parentField.getAnnotatedType();
            int childIndex = CollectionUtils.identityIndexOf(node, node.getParent().getChildren());
            if (childIndex != -1) {
                AnnotatedType[] annotatedTypes = apt.getAnnotatedActualTypeArguments();
                return annotatedTypes[childIndex].getAnnotations();
            }
        }
        return EMPTY_ANNOTATIONS;
    }
}

