/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assignment;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.instancio.Assignment;
import org.instancio.RandomFunction;
import org.instancio.TargetSelector;
import org.instancio.documentation.InternalApi;
import org.instancio.generator.Generator;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.assignment.GeneratorHolder;

@InternalApi
public final class InternalAssignment
implements Assignment,
Flattener<InternalAssignment> {
    private final TargetSelector origin;
    private final Predicate<?> originPredicate;
    private final TargetSelector destination;
    private final GeneratorHolder generatorHolder;
    private final Generator<?> generator;
    private final RandomFunction<?, ?> valueMapper;

    private InternalAssignment(Builder builder) {
        this.origin = builder.origin;
        this.originPredicate = builder.originPredicate;
        this.destination = builder.destination;
        this.generatorHolder = builder.generatorHolder;
        this.generator = builder.generator;
        this.valueMapper = builder.valueMapper;
    }

    public TargetSelector getOrigin() {
        return this.origin;
    }

    public <T> Predicate<T> getOriginPredicate() {
        return this.originPredicate;
    }

    public TargetSelector getDestination() {
        return this.destination;
    }

    public GeneratorHolder getGeneratorHolder() {
        return this.generatorHolder;
    }

    public <T> Generator<T> getGenerator() {
        return this.generator;
    }

    public <S, T> RandomFunction<S, T> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public List<InternalAssignment> flatten() {
        return Collections.singletonList(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.origin = this.origin;
        builder.originPredicate = this.originPredicate;
        builder.destination = this.destination;
        builder.generatorHolder = this.generatorHolder;
        builder.generator = this.generator;
        builder.valueMapper = this.valueMapper;
        return builder;
    }

    public String toString() {
        return String.format("InternalAssignment[origin=%s, destination=%s]", this.origin, this.destination);
    }

    public static final class Builder {
        private TargetSelector origin;
        private Predicate<?> originPredicate;
        private TargetSelector destination;
        private GeneratorHolder generatorHolder;
        private Generator<?> generator;
        private RandomFunction<?, ?> valueMapper;

        private Builder() {
        }

        public Builder origin(TargetSelector origin) {
            this.origin = ApiValidator.notNull(origin, "origin selector must not be null");
            return this;
        }

        public <T> Builder originPredicate(Predicate<T> originPredicate) {
            this.originPredicate = originPredicate;
            return this;
        }

        public Builder destination(TargetSelector destination) {
            this.destination = ApiValidator.notNull(destination, "destination selector must not be null");
            return this;
        }

        public Builder generatorHolder(GeneratorHolder generatorHolder) {
            this.generatorHolder = generatorHolder;
            return this;
        }

        public Builder generator(Generator<?> generator) {
            this.generator = generator;
            return this;
        }

        public Builder valueMapper(RandomFunction<?, ?> valueMapper) {
            this.valueMapper = valueMapper;
            return this;
        }

        public InternalAssignment build() {
            return new InternalAssignment(this);
        }
    }
}

