/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assignment;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.instancio.Assignment;
import org.instancio.RandomFunction;
import org.instancio.TargetSelector;
import org.instancio.ValueOfOriginDestination;
import org.instancio.ValueOfOriginDestinationPredicate;
import org.instancio.internal.Flattener;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.assignment.InternalValueOfOriginDestinationPredicate;

public class InternalValueOfOriginDestination
implements ValueOfOriginDestination,
Assignment,
Flattener<InternalAssignment> {
    private final TargetSelector origin;
    private final TargetSelector destination;
    private Predicate<?> predicate;
    private RandomFunction<?, ?> valueMapper;

    public InternalValueOfOriginDestination(TargetSelector origin, TargetSelector destination) {
        this.origin = origin;
        this.destination = destination;
    }

    @Override
    public <T, R> ValueOfOriginDestinationPredicate as(Function<T, R> f) {
        this.valueMapper = (arg, random) -> f.apply(arg);
        return new InternalValueOfOriginDestinationPredicate(this.origin, this.destination, this.predicate, this.valueMapper);
    }

    @Override
    public <T, R> ValueOfOriginDestinationPredicate as(RandomFunction<T, R> valueMapper) {
        this.valueMapper = valueMapper;
        return new InternalValueOfOriginDestinationPredicate(this.origin, this.destination, this.predicate, valueMapper);
    }

    @Override
    public <T> Assignment when(Predicate<T> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public List<InternalAssignment> flatten() {
        return Collections.singletonList(InternalAssignment.builder().origin(this.origin).destination(this.destination).valueMapper(this.valueMapper).originPredicate(this.predicate).build());
    }
}

