/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMaps;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.InternalSelector;

final class SelectorNodeMatchesCollector {
    private final SelectorMap<?> assignDestinationToAssignmentsMap;
    private final SelectorMap<?> assignOriginToDestinationSelectorsMap;
    private final SelectorMap<?> feedSelectorMap;
    private final SelectorMap<?> filterSelectorMap;
    private final SelectorMap<?> generatorSelectorMap;
    private final SelectorMap<?> ignoredSelectorMap;
    private final SelectorMap<?> nullableSelectorMap;
    private final SelectorMap<?> onCompleteCallbackSelectorMap;
    private final SelectorMap<?> setModelSelectorMap;
    private final SelectorMap<?> subtypeSelectorMap;

    SelectorNodeMatchesCollector(SelectorMaps selectorMaps) {
        this.assignDestinationToAssignmentsMap = selectorMaps.getAssignmentSelectorMap().getDestinationToAssignmentsMap();
        this.assignOriginToDestinationSelectorsMap = selectorMaps.getAssignmentSelectorMap().getOriginToDestinationSelectorsMap();
        this.feedSelectorMap = selectorMaps.getFeedSelectorMap().getSelectorMap();
        this.filterSelectorMap = selectorMaps.getFilterSelectorMap().getSelectorMap();
        this.generatorSelectorMap = selectorMaps.getGeneratorSelectorMap().getSelectorMap();
        this.ignoredSelectorMap = selectorMaps.getIgnoreSelectorMap().getSelectorMap();
        this.nullableSelectorMap = selectorMaps.getWithNullableSelectorMap().getSelectorMap();
        this.onCompleteCallbackSelectorMap = selectorMaps.getOnCompleteSelectorMap().getSelectorMap();
        this.setModelSelectorMap = selectorMaps.getSetModelSelectorMap().getSelectorMap();
        this.subtypeSelectorMap = selectorMaps.getSubtypeSelectorMap().getSelectorMap();
    }

    public Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> getNodeMatches(InternalNode rootNode) {
        EnumMap<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> map = new EnumMap<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>>(ApiMethodSelector.class);
        ArrayDeque<InternalNode> queue = new ArrayDeque<InternalNode>();
        queue.offer(rootNode);
        while (!queue.isEmpty()) {
            InternalNode node = (InternalNode)queue.poll();
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.APPLY_FEED, node, this.feedSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ASSIGN_DESTINATION, node, this.assignDestinationToAssignmentsMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ASSIGN_ORIGIN, node, this.assignOriginToDestinationSelectorsMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.FILTER, node, this.filterSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.GENERATE, node, this.generatorSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.IGNORE, node, this.ignoredSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ON_COMPLETE, node, this.onCompleteCallbackSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SET_MODEL, node, this.setModelSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SET, node, this.generatorSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SUBTYPE, node, this.subtypeSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SUPPLY, node, this.generatorSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.WITH_NULLABLE, node, this.nullableSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.WITH_UNIQUE, node, this.filterSelectorMap);
            queue.addAll(node.getChildren());
        }
        return map;
    }

    private static void collectNodes(Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> resultsMap, ApiMethodSelector apiMethodSelector, InternalNode node, SelectorMap<?> selectorMap) {
        Map selectorNodeMap = resultsMap.computeIfAbsent(apiMethodSelector, k -> new LinkedHashMap());
        Set<TargetSelector> selectors = selectorMap.getSelectors(node);
        for (TargetSelector selector : selectors) {
            InternalSelector internalSelector = (InternalSelector)selector;
            if (internalSelector.getApiMethodSelector() != apiMethodSelector) continue;
            Set nodes = selectorNodeMap.computeIfAbsent(selector, k -> new LinkedHashSet());
            nodes.add(node);
        }
    }

    public List<TargetSelector> getUnusedSelectors() {
        ArrayList<TargetSelector> results = new ArrayList<TargetSelector>();
        results.addAll(this.assignDestinationToAssignmentsMap.getUnusedKeys());
        results.addAll(this.assignOriginToDestinationSelectorsMap.getUnusedKeys());
        results.addAll(this.feedSelectorMap.getUnusedKeys());
        results.addAll(this.filterSelectorMap.getUnusedKeys());
        results.addAll(this.generatorSelectorMap.getUnusedKeys());
        results.addAll(this.ignoredSelectorMap.getUnusedKeys());
        results.addAll(this.nullableSelectorMap.getUnusedKeys());
        results.addAll(this.onCompleteCallbackSelectorMap.getUnusedKeys());
        results.addAll(this.setModelSelectorMap.getUnusedKeys());
        results.addAll(this.subtypeSelectorMap.getUnusedKeys());
        return results;
    }
}

