/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.csv;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.instancio.feed.DataSource;
import org.instancio.internal.feed.DataLoader;
import org.instancio.internal.feed.csv.InternalCsvFormatOptions;
import org.instancio.settings.FeedDataTrim;

public final class CsvDataLoader
implements DataLoader<List<String[]>> {
    private final FeedDataTrim feedDataTrim;
    private final String commentChar;
    private final char delimiter;

    CsvDataLoader(InternalCsvFormatOptions formatOptions) {
        this.feedDataTrim = formatOptions.getFeedDataTrim();
        this.commentChar = formatOptions.getCommentPrefix();
        this.delimiter = formatOptions.getDelimiter();
    }

    @Override
    public List<String[]> load(DataSource dataSource) throws Exception {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStream(dataSource)));){
            String line;
            ArrayList<String[]> results = new ArrayList<String[]>();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith(this.commentChar)) continue;
                String[] tokens = this.parseLine(line);
                results.add(tokens);
            }
            ArrayList<String[]> arrayList = results;
            return arrayList;
        }
    }

    private String[] parseLine(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        boolean inQuotes = false;
        boolean isQuotedToken = false;
        int index = 0;
        while (index < line.length()) {
            char currentChar = line.charAt(index);
            if (currentChar == '\"') {
                isQuotedToken = true;
                if (inQuotes && index + 1 < line.length() && line.charAt(index + 1) == '\"') {
                    ++index;
                } else {
                    inQuotes = !inQuotes;
                    this.resetToken(inQuotes, currentToken);
                }
            } else if (currentChar == this.delimiter && !inQuotes) {
                tokens.add(this.trimToken(currentToken.toString(), isQuotedToken));
                currentToken.setLength(0);
                isQuotedToken = false;
            } else if (currentChar != ' ' || inQuotes || !isQuotedToken) {
                currentToken.append(currentChar);
            }
            if (++index != line.length()) continue;
            tokens.add(this.trimToken(currentToken.toString(), isQuotedToken));
        }
        return tokens.toArray(new String[0]);
    }

    private void resetToken(boolean inQuotes, StringBuilder currentToken) {
        if (inQuotes) {
            currentToken.setLength(0);
        }
    }

    private String trimToken(String token, boolean isQuotedToken) {
        String result = token;
        if (result.isEmpty()) {
            return null;
        }
        if (isQuotedToken) {
            return result;
        }
        if (this.feedDataTrim == FeedDataTrim.UNQUOTED) {
            return result.trim();
        }
        if (result.startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result.replace("\"\"", "\"");
    }
}

