/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.function.BiFunction;
import org.instancio.internal.feed.CachingDataLoader;
import org.instancio.internal.feed.DataStore;
import org.instancio.internal.feed.InternalFeed;
import org.instancio.internal.feed.InternalFeedContext;
import org.instancio.internal.feed.ResourceHandler;
import org.instancio.internal.feed.json.JsonDataLoader;
import org.instancio.internal.feed.json.JsonDataStore;
import org.instancio.internal.feed.json.JsonFeed;

public final class JsonResourceHandler
implements ResourceHandler {
    private final CachingDataLoader cachingDataLoader = new CachingDataLoader();

    @Override
    public InternalFeed createFeed(InternalFeedContext<?> feedContext) {
        JsonDataLoader dataLoader = new JsonDataLoader();
        BiFunction<String, List<?>, DataStore<?>> tagKeyToDataStoreMapper = (tagKey, data) -> new JsonDataStore((String)tagKey, (List<JsonNode>)data);
        DataStore<JsonNode> dataStore = this.cachingDataLoader.loadData(feedContext, dataLoader, tagKeyToDataStoreMapper);
        return new JsonFeed(feedContext, dataStore);
    }
}

