/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.SpiGeneratorResolver;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

class SpiGeneratorNodeHandler
implements NodeHandler {
    private final ModelContext modelContext;
    private final SpiGeneratorResolver spiGeneratorResolver;

    SpiGeneratorNodeHandler(ModelContext modelContext, SpiGeneratorResolver spiGeneratorResolver) {
        this.modelContext = modelContext;
        this.spiGeneratorResolver = spiGeneratorResolver;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        Generator<?> generator = this.spiGeneratorResolver.getSpiGenerator(node);
        if (generator == null) {
            return GeneratorResult.emptyResult();
        }
        Object value = generator.generate(this.modelContext.getRandom());
        return GeneratorResult.create(value, generator.hints());
    }
}

