/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.checksum;

import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.Mod11Spec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.checksum.BaseModCheckGenerator;
import org.instancio.internal.generator.checksum.VariableLengthModCheckGenerator;

public class Mod11Generator
extends VariableLengthModCheckGenerator
implements Mod11Spec {
    private static final int DEFAULT_THRESHOLD = Integer.MAX_VALUE;
    private static final char DEFAULT_TREAT_10_AS = 'X';
    private static final char DEFAULT_TREAT_11_AS = '0';
    private int threshold = Integer.MAX_VALUE;
    private char treatCheck10As = (char)88;
    private char treatCheck11As = (char)48;
    private BaseModCheckGenerator.Direction direction = BaseModCheckGenerator.Direction.RIGHT_TO_LEFT;

    public Mod11Generator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "mod11()";
    }

    @Override
    public Mod11Generator length(int length) {
        super.length(length);
        return this;
    }

    @Override
    public Mod11Generator threshold(int threshold) {
        ApiValidator.isTrue(threshold >= 0, "threshold must not be negative: %s", threshold);
        this.threshold = threshold;
        return this;
    }

    @Override
    public Mod11Generator treatCheck10As(char treatCheck10As) {
        this.treatCheck10As = treatCheck10As;
        return this;
    }

    @Override
    public Mod11Generator treatCheck11As(char treatCheck11As) {
        this.treatCheck11As = treatCheck11As;
        return this;
    }

    @Override
    public Mod11Generator startIndex(int idx) {
        super.startIndex(idx);
        return this;
    }

    @Override
    public Mod11Generator endIndex(int idx) {
        super.endIndex(idx);
        return this;
    }

    @Override
    public Mod11Generator checkDigitIndex(int idx) {
        super.checkDigitIndex(idx);
        return this;
    }

    @Override
    protected int even(int position) {
        return this.weight(position);
    }

    @Override
    protected int odd(int position) {
        return this.weight(position);
    }

    @Override
    public Mod11Generator leftToRight() {
        this.direction(BaseModCheckGenerator.Direction.LEFT_TO_RIGHT);
        return this;
    }

    public Mod11Generator direction(BaseModCheckGenerator.Direction direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public Mod11Generator nullable() {
        super.nullable();
        return this;
    }

    public Mod11Generator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    protected boolean sumDigits() {
        return false;
    }

    @Override
    protected BaseModCheckGenerator.Direction direction() {
        return this.direction;
    }

    @Override
    protected int base() {
        return 11;
    }

    @Override
    protected char treat10As() {
        return this.treatCheck10As;
    }

    @Override
    protected char treat11As() {
        return this.treatCheck11As;
    }

    private int weight(int position) {
        return position % (this.threshold - 1) + 2;
    }
}

