/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.lang.reflect.Constructor;
import org.instancio.internal.util.ExceptionUtils;
import sun.reflect.ReflectionFactory;

final class ReflectionFactoryHelper {
    static <T> T createInstance(Class<T> klass) {
        try {
            Constructor<T> ctor = ReflectionFactoryHelper.getNewConstructorForSerialization(klass);
            return ctor.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            ExceptionUtils.logException("Error instantiating {} via newConstructorForSerialization", ex, klass);
            return null;
        }
    }

    private static <T> Constructor<T> getNewConstructorForSerialization(Class<T> type) throws NoSuchMethodException {
        Constructor constructor = Object.class.getConstructor(null);
        return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(type, constructor);
    }

    private ReflectionFactoryHelper() {
    }
}

