/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.instancio.internal.RootType;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TypeHelper.class);
    private final RootType rootType;

    TypeHelper(RootType rootType) {
        this.rootType = rootType;
    }

    Type resolveTypeVariable(@NotNull TypeVariable<?> typeVar, @Nullable InternalNode parent) {
        Type mappedType = parent == null ? typeVar : parent.getTypeMap().getOrDefault(typeVar, typeVar);
        for (InternalNode ancestor = parent; (mappedType == null || mappedType instanceof TypeVariable) && ancestor != null; ancestor = ancestor.getParent()) {
            Type rootTypeMapping = this.rootType.getTypeMapping(mappedType);
            if (rootTypeMapping != null) {
                return rootTypeMapping;
            }
            mappedType = ancestor.getTypeMap().getOrDefault(mappedType, mappedType);
            if (mappedType instanceof Class || mappedType instanceof ParameterizedType) break;
        }
        return mappedType == typeVar ? null : mappedType;
    }

    Map<Type, Type> createSuperclassTypeMap(Class<?> targetClass) {
        HashMap<Type, Type> resultTypeMap = new HashMap<Type, Type>();
        this.traverseHierarchy(targetClass, resultTypeMap);
        if (resultTypeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        LOG.trace("Created superclass type map: {}", resultTypeMap);
        return resultTypeMap;
    }

    private void traverseHierarchy(Class<?> clazz, Map<Type, Type> resultTypeMap) {
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        Type supertype = clazz.getGenericSuperclass();
        if (supertype instanceof ParameterizedType) {
            TypeHelper.addTypeParameters((ParameterizedType)supertype, resultTypeMap);
        }
        if (supertype != null) {
            this.traverseHierarchy(TypeUtils.getRawType(supertype), resultTypeMap);
        }
    }

    Map<Type, Type> createBridgeTypeMap(Class<?> source, Class<?> target) {
        Type supertype;
        TypeVariable<Class<?>>[] supertypeParams;
        if (source.equals(target)) {
            return Collections.emptyMap();
        }
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        TypeVariable<Class<?>>[] subtypeParams = target.getTypeParameters();
        if (subtypeParams.length == (supertypeParams = source.getTypeParameters()).length) {
            for (int i = 0; i < subtypeParams.length; ++i) {
                typeMap.put(subtypeParams[i], supertypeParams[i]);
            }
        }
        if ((supertype = target.getGenericSuperclass()) instanceof ParameterizedType) {
            TypeHelper.addTypeParameters((ParameterizedType)supertype, typeMap);
        }
        return typeMap;
    }

    private static void addTypeParameters(ParameterizedType parameterizedType, Map<Type, Type> typeMap) {
        Type[] typeArgs;
        Class rawSuperclassType = TypeUtils.getRawType(parameterizedType);
        TypeVariable<Class<T>>[] typeVars = rawSuperclassType.getTypeParameters();
        if (typeVars.length == (typeArgs = parameterizedType.getActualTypeArguments()).length) {
            for (int i = 0; i < typeVars.length; ++i) {
                typeMap.put(typeVars[i], typeArgs[i]);
            }
        }
    }
}

