/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnicodeBlocks {
    private static final Logger LOG = LoggerFactory.getLogger(UnicodeBlocks.class);
    private final Map<Character.UnicodeBlock, BlockRange> blockRangeMap = new HashMap<Character.UnicodeBlock, BlockRange>(800);
    private static final BlockRange[] BLOCK_RANGES = new BlockRange[]{new BlockRange(0, 127, "BASIC_LATIN"), new BlockRange(128, 255, "LATIN_1_SUPPLEMENT"), new BlockRange(256, 383, "LATIN_EXTENDED_A"), new BlockRange(384, 591, "LATIN_EXTENDED_B"), new BlockRange(592, 687, "IPA_EXTENSIONS"), new BlockRange(688, 767, "SPACING_MODIFIER_LETTERS"), new BlockRange(768, 879, "COMBINING_DIACRITICAL_MARKS"), new BlockRange(880, 1023, "GREEK"), new BlockRange(1024, 1279, "CYRILLIC"), new BlockRange(1280, 1327, "CYRILLIC_SUPPLEMENTARY"), new BlockRange(1328, 1423, "ARMENIAN"), new BlockRange(1424, 1535, "HEBREW"), new BlockRange(1536, 1791, "ARABIC"), new BlockRange(1792, 1871, "SYRIAC"), new BlockRange(1872, 1919, "ARABIC_SUPPLEMENT"), new BlockRange(1920, 1983, "THAANA"), new BlockRange(1984, 2047, "NKO"), new BlockRange(2048, 2111, "SAMARITAN"), new BlockRange(2112, 2143, "MANDAIC"), new BlockRange(2144, 2159, "SYRIAC_SUPPLEMENT"), new BlockRange(2160, 2207, "ARABIC_EXTENDED_B"), new BlockRange(2208, 2303, "ARABIC_EXTENDED_A"), new BlockRange(2304, 2431, "DEVANAGARI"), new BlockRange(2432, 2559, "BENGALI"), new BlockRange(2560, 2687, "GURMUKHI"), new BlockRange(2688, 2815, "GUJARATI"), new BlockRange(2816, 2943, "ORIYA"), new BlockRange(2944, 3071, "TAMIL"), new BlockRange(3072, 3199, "TELUGU"), new BlockRange(3200, 3327, "KANNADA"), new BlockRange(3328, 3455, "MALAYALAM"), new BlockRange(3456, 3583, "SINHALA"), new BlockRange(3584, 3711, "THAI"), new BlockRange(3712, 3839, "LAO"), new BlockRange(3840, 4095, "TIBETAN"), new BlockRange(4096, 4255, "MYANMAR"), new BlockRange(4256, 4351, "GEORGIAN"), new BlockRange(4352, 4607, "HANGUL_JAMO"), new BlockRange(4608, 4991, "ETHIOPIC"), new BlockRange(4992, 5023, "ETHIOPIC_SUPPLEMENT"), new BlockRange(5024, 5119, "CHEROKEE"), new BlockRange(5120, 5759, "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS"), new BlockRange(5760, 5791, "OGHAM"), new BlockRange(5792, 5887, "RUNIC"), new BlockRange(5888, 5919, "TAGALOG"), new BlockRange(5920, 5951, "HANUNOO"), new BlockRange(5952, 5983, "BUHID"), new BlockRange(5984, 6015, "TAGBANWA"), new BlockRange(6016, 6143, "KHMER"), new BlockRange(6144, 6319, "MONGOLIAN"), new BlockRange(6320, 6399, "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED"), new BlockRange(6400, 6479, "LIMBU"), new BlockRange(6480, 6527, "TAI_LE"), new BlockRange(6528, 6623, "NEW_TAI_LUE"), new BlockRange(6624, 6655, "KHMER_SYMBOLS"), new BlockRange(6656, 6687, "BUGINESE"), new BlockRange(6688, 6831, "TAI_THAM"), new BlockRange(6832, 6911, "COMBINING_DIACRITICAL_MARKS_EXTENDED"), new BlockRange(6912, 7039, "BALINESE"), new BlockRange(7040, 7103, "SUNDANESE"), new BlockRange(7104, 7167, "BATAK"), new BlockRange(7168, 7247, "LEPCHA"), new BlockRange(7248, 7295, "OL_CHIKI"), new BlockRange(7296, 7311, "CYRILLIC_EXTENDED_C"), new BlockRange(7312, 7359, "GEORGIAN_EXTENDED"), new BlockRange(7360, 7375, "SUNDANESE_SUPPLEMENT"), new BlockRange(7376, 7423, "VEDIC_EXTENSIONS"), new BlockRange(7424, 7551, "PHONETIC_EXTENSIONS"), new BlockRange(7552, 7615, "PHONETIC_EXTENSIONS_SUPPLEMENT"), new BlockRange(7616, 7679, "COMBINING_DIACRITICAL_MARKS_SUPPLEMENT"), new BlockRange(7680, 7935, "LATIN_EXTENDED_ADDITIONAL"), new BlockRange(7936, 8191, "GREEK_EXTENDED"), new BlockRange(8192, 8303, "GENERAL_PUNCTUATION"), new BlockRange(8304, 8351, "SUPERSCRIPTS_AND_SUBSCRIPTS"), new BlockRange(8352, 8399, "CURRENCY_SYMBOLS"), new BlockRange(8400, 8447, "COMBINING_MARKS_FOR_SYMBOLS"), new BlockRange(8448, 8527, "LETTERLIKE_SYMBOLS"), new BlockRange(8528, 8591, "NUMBER_FORMS"), new BlockRange(8592, 8703, "ARROWS"), new BlockRange(8704, 8959, "MATHEMATICAL_OPERATORS"), new BlockRange(8960, 9215, "MISCELLANEOUS_TECHNICAL"), new BlockRange(9216, 9279, "CONTROL_PICTURES"), new BlockRange(9280, 9311, "OPTICAL_CHARACTER_RECOGNITION"), new BlockRange(9312, 9471, "ENCLOSED_ALPHANUMERICS"), new BlockRange(9472, 9599, "BOX_DRAWING"), new BlockRange(9600, 9631, "BLOCK_ELEMENTS"), new BlockRange(9632, 9727, "GEOMETRIC_SHAPES"), new BlockRange(9728, 9983, "MISCELLANEOUS_SYMBOLS"), new BlockRange(9984, 10175, "DINGBATS"), new BlockRange(10176, 10223, "MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A"), new BlockRange(10224, 10239, "SUPPLEMENTAL_ARROWS_A"), new BlockRange(10240, 10495, "BRAILLE_PATTERNS"), new BlockRange(10496, 10623, "SUPPLEMENTAL_ARROWS_B"), new BlockRange(10624, 10751, "MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B"), new BlockRange(10752, 11007, "SUPPLEMENTAL_MATHEMATICAL_OPERATORS"), new BlockRange(11008, 11263, "MISCELLANEOUS_SYMBOLS_AND_ARROWS"), new BlockRange(11264, 11359, "GLAGOLITIC"), new BlockRange(11360, 11391, "LATIN_EXTENDED_C"), new BlockRange(11392, 11519, "COPTIC"), new BlockRange(11520, 11567, "GEORGIAN_SUPPLEMENT"), new BlockRange(11568, 11647, "TIFINAGH"), new BlockRange(11648, 11743, "ETHIOPIC_EXTENDED"), new BlockRange(11744, 11775, "CYRILLIC_EXTENDED_A"), new BlockRange(11776, 11903, "SUPPLEMENTAL_PUNCTUATION"), new BlockRange(11904, 12031, "CJK_RADICALS_SUPPLEMENT"), new BlockRange(12032, 12255, "KANGXI_RADICALS"), new BlockRange(12272, 12287, "IDEOGRAPHIC_DESCRIPTION_CHARACTERS"), new BlockRange(12288, 12351, "CJK_SYMBOLS_AND_PUNCTUATION"), new BlockRange(12352, 12447, "HIRAGANA"), new BlockRange(12448, 12543, "KATAKANA"), new BlockRange(12544, 12591, "BOPOMOFO"), new BlockRange(12592, 12687, "HANGUL_COMPATIBILITY_JAMO"), new BlockRange(12688, 12703, "KANBUN"), new BlockRange(12704, 12735, "BOPOMOFO_EXTENDED"), new BlockRange(12736, 12783, "CJK_STROKES"), new BlockRange(12784, 12799, "KATAKANA_PHONETIC_EXTENSIONS"), new BlockRange(12800, 13055, "ENCLOSED_CJK_LETTERS_AND_MONTHS"), new BlockRange(13056, 13311, "CJK_COMPATIBILITY"), new BlockRange(13312, 19903, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A"), new BlockRange(19904, 19967, "YIJING_HEXAGRAM_SYMBOLS"), new BlockRange(19968, 40959, "CJK_UNIFIED_IDEOGRAPHS"), new BlockRange(40960, 42127, "YI_SYLLABLES"), new BlockRange(42128, 42191, "YI_RADICALS"), new BlockRange(42192, 42239, "LISU"), new BlockRange(42240, 42559, "VAI"), new BlockRange(42560, 42655, "CYRILLIC_EXTENDED_B"), new BlockRange(42656, 42751, "BAMUM"), new BlockRange(42752, 42783, "MODIFIER_TONE_LETTERS"), new BlockRange(42784, 43007, "LATIN_EXTENDED_D"), new BlockRange(43008, 43055, "SYLOTI_NAGRI"), new BlockRange(43056, 43071, "COMMON_INDIC_NUMBER_FORMS"), new BlockRange(43072, 43135, "PHAGS_PA"), new BlockRange(43136, 43231, "SAURASHTRA"), new BlockRange(43232, 43263, "DEVANAGARI_EXTENDED"), new BlockRange(43264, 43311, "KAYAH_LI"), new BlockRange(43312, 43359, "REJANG"), new BlockRange(43360, 43391, "HANGUL_JAMO_EXTENDED_A"), new BlockRange(43392, 43487, "JAVANESE"), new BlockRange(43488, 43519, "MYANMAR_EXTENDED_B"), new BlockRange(43520, 43615, "CHAM"), new BlockRange(43616, 43647, "MYANMAR_EXTENDED_A"), new BlockRange(43648, 43743, "TAI_VIET"), new BlockRange(43744, 43775, "MEETEI_MAYEK_EXTENSIONS"), new BlockRange(43776, 43823, "ETHIOPIC_EXTENDED_A"), new BlockRange(43824, 43887, "LATIN_EXTENDED_E"), new BlockRange(43888, 43967, "CHEROKEE_SUPPLEMENT"), new BlockRange(43968, 44031, "MEETEI_MAYEK"), new BlockRange(44032, 55215, "HANGUL_SYLLABLES"), new BlockRange(55216, 55295, "HANGUL_JAMO_EXTENDED_B"), new BlockRange(55296, 56191, "HIGH_SURROGATES"), new BlockRange(56192, 56319, "HIGH_PRIVATE_USE_SURROGATES"), new BlockRange(56320, 57343, "LOW_SURROGATES"), new BlockRange(57344, 63743, "PRIVATE_USE_AREA"), new BlockRange(63744, 64255, "CJK_COMPATIBILITY_IDEOGRAPHS"), new BlockRange(64256, 64335, "ALPHABETIC_PRESENTATION_FORMS"), new BlockRange(64336, 65023, "ARABIC_PRESENTATION_FORMS_A"), new BlockRange(65024, 65039, "VARIATION_SELECTORS"), new BlockRange(65040, 65055, "VERTICAL_FORMS"), new BlockRange(65056, 65071, "COMBINING_HALF_MARKS"), new BlockRange(65072, 65103, "CJK_COMPATIBILITY_FORMS"), new BlockRange(65104, 65135, "SMALL_FORM_VARIANTS"), new BlockRange(65136, 65279, "ARABIC_PRESENTATION_FORMS_B"), new BlockRange(65280, 65519, "HALFWIDTH_AND_FULLWIDTH_FORMS"), new BlockRange(65520, 65535, "SPECIALS"), new BlockRange(65536, 65663, "LINEAR_B_SYLLABARY"), new BlockRange(65664, 65791, "LINEAR_B_IDEOGRAMS"), new BlockRange(65792, 65855, "AEGEAN_NUMBERS"), new BlockRange(65856, 65935, "ANCIENT_GREEK_NUMBERS"), new BlockRange(65936, 65999, "ANCIENT_SYMBOLS"), new BlockRange(66000, 66047, "PHAISTOS_DISC"), new BlockRange(66176, 66207, "LYCIAN"), new BlockRange(66208, 66271, "CARIAN"), new BlockRange(66272, 66303, "COPTIC_EPACT_NUMBERS"), new BlockRange(66304, 66351, "OLD_ITALIC"), new BlockRange(66352, 66383, "GOTHIC"), new BlockRange(66384, 66431, "OLD_PERMIC"), new BlockRange(66432, 66463, "UGARITIC"), new BlockRange(66464, 66527, "OLD_PERSIAN"), new BlockRange(66560, 66639, "DESERET"), new BlockRange(66640, 66687, "SHAVIAN"), new BlockRange(66688, 66735, "OSMANYA"), new BlockRange(66736, 66815, "OSAGE"), new BlockRange(66816, 66863, "ELBASAN"), new BlockRange(66864, 66927, "CAUCASIAN_ALBANIAN"), new BlockRange(66928, 67007, "VITHKUQI"), new BlockRange(67072, 67455, "LINEAR_A"), new BlockRange(67456, 67519, "LATIN_EXTENDED_F"), new BlockRange(67584, 67647, "CYPRIOT_SYLLABARY"), new BlockRange(67648, 67679, "IMPERIAL_ARAMAIC"), new BlockRange(67680, 67711, "PALMYRENE"), new BlockRange(67712, 67759, "NABATAEAN"), new BlockRange(67808, 67839, "HATRAN"), new BlockRange(67840, 67871, "PHOENICIAN"), new BlockRange(67872, 67903, "LYDIAN"), new BlockRange(67968, 67999, "MEROITIC_HIEROGLYPHS"), new BlockRange(68000, 68095, "MEROITIC_CURSIVE"), new BlockRange(68096, 68191, "KHAROSHTHI"), new BlockRange(68192, 68223, "OLD_SOUTH_ARABIAN"), new BlockRange(68224, 68255, "OLD_NORTH_ARABIAN"), new BlockRange(68288, 68351, "MANICHAEAN"), new BlockRange(68352, 68415, "AVESTAN"), new BlockRange(68416, 68447, "INSCRIPTIONAL_PARTHIAN"), new BlockRange(68448, 68479, "INSCRIPTIONAL_PAHLAVI"), new BlockRange(68480, 68527, "PSALTER_PAHLAVI"), new BlockRange(68608, 68687, "OLD_TURKIC"), new BlockRange(68736, 68863, "OLD_HUNGARIAN"), new BlockRange(68864, 68927, "HANIFI_ROHINGYA"), new BlockRange(69216, 69247, "RUMI_NUMERAL_SYMBOLS"), new BlockRange(69248, 69311, "YEZIDI"), new BlockRange(69312, 69375, "ARABIC_EXTENDED_C"), new BlockRange(69376, 69423, "OLD_SOGDIAN"), new BlockRange(69424, 69487, "SOGDIAN"), new BlockRange(69488, 69551, "OLD_UYGHUR"), new BlockRange(69552, 69599, "CHORASMIAN"), new BlockRange(69600, 69631, "ELYMAIC"), new BlockRange(69632, 69759, "BRAHMI"), new BlockRange(69760, 69839, "KAITHI"), new BlockRange(69840, 69887, "SORA_SOMPENG"), new BlockRange(69888, 69967, "CHAKMA"), new BlockRange(69968, 70015, "MAHAJANI"), new BlockRange(70016, 70111, "SHARADA"), new BlockRange(70112, 70143, "SINHALA_ARCHAIC_NUMBERS"), new BlockRange(70144, 70223, "KHOJKI"), new BlockRange(70272, 70319, "MULTANI"), new BlockRange(70320, 70399, "KHUDAWADI"), new BlockRange(70400, 70527, "GRANTHA"), new BlockRange(70656, 70783, "NEWA"), new BlockRange(70784, 70879, "TIRHUTA"), new BlockRange(71040, 71167, "SIDDHAM"), new BlockRange(71168, 71263, "MODI"), new BlockRange(71264, 71295, "MONGOLIAN_SUPPLEMENT"), new BlockRange(71296, 71375, "TAKRI"), new BlockRange(71424, 71503, "AHOM"), new BlockRange(71680, 71759, "DOGRA"), new BlockRange(71840, 71935, "WARANG_CITI"), new BlockRange(71936, 72031, "DIVES_AKURU"), new BlockRange(72096, 72191, "NANDINAGARI"), new BlockRange(72192, 72271, "ZANABAZAR_SQUARE"), new BlockRange(72272, 72367, "SOYOMBO"), new BlockRange(72368, 72383, "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_A"), new BlockRange(72384, 72447, "PAU_CIN_HAU"), new BlockRange(72448, 72543, "DEVANAGARI_EXTENDED_A"), new BlockRange(72704, 72815, "BHAIKSUKI"), new BlockRange(72816, 72895, "MARCHEN"), new BlockRange(72960, 73055, "MASARAM_GONDI"), new BlockRange(73056, 73135, "GUNJALA_GONDI"), new BlockRange(73440, 73471, "MAKASAR"), new BlockRange(73472, 73567, "KAWI"), new BlockRange(73648, 73663, "LISU_SUPPLEMENT"), new BlockRange(73664, 73727, "TAMIL_SUPPLEMENT"), new BlockRange(73728, 74751, "CUNEIFORM"), new BlockRange(74752, 74879, "CUNEIFORM_NUMBERS_AND_PUNCTUATION"), new BlockRange(74880, 75087, "EARLY_DYNASTIC_CUNEIFORM"), new BlockRange(77712, 77823, "CYPRO_MINOAN"), new BlockRange(77824, 78895, "EGYPTIAN_HIEROGLYPHS"), new BlockRange(78896, 78943, "EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS"), new BlockRange(82944, 83583, "ANATOLIAN_HIEROGLYPHS"), new BlockRange(92160, 92735, "BAMUM_SUPPLEMENT"), new BlockRange(92736, 92783, "MRO"), new BlockRange(92784, 92879, "TANGSA"), new BlockRange(92880, 92927, "BASSA_VAH"), new BlockRange(92928, 93071, "PAHAWH_HMONG"), new BlockRange(93760, 93855, "MEDEFAIDRIN"), new BlockRange(93952, 94111, "MIAO"), new BlockRange(94176, 94207, "IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION"), new BlockRange(94208, 100351, "TANGUT"), new BlockRange(100352, 101119, "TANGUT_COMPONENTS"), new BlockRange(101120, 101631, "KHITAN_SMALL_SCRIPT"), new BlockRange(101632, 101759, "TANGUT_SUPPLEMENT"), new BlockRange(110576, 110591, "KANA_EXTENDED_B"), new BlockRange(110592, 110847, "KANA_SUPPLEMENT"), new BlockRange(110848, 110895, "KANA_EXTENDED_A"), new BlockRange(110896, 110959, "SMALL_KANA_EXTENSION"), new BlockRange(110960, 111359, "NUSHU"), new BlockRange(113664, 113823, "DUPLOYAN"), new BlockRange(113824, 113839, "SHORTHAND_FORMAT_CONTROLS"), new BlockRange(118528, 118735, "ZNAMENNY_MUSICAL_NOTATION"), new BlockRange(118784, 119039, "BYZANTINE_MUSICAL_SYMBOLS"), new BlockRange(119040, 119295, "MUSICAL_SYMBOLS"), new BlockRange(119296, 119375, "ANCIENT_GREEK_MUSICAL_NOTATION"), new BlockRange(119488, 119519, "KAKTOVIK_NUMERALS"), new BlockRange(119520, 119551, "MAYAN_NUMERALS"), new BlockRange(119552, 119647, "TAI_XUAN_JING_SYMBOLS"), new BlockRange(119648, 119679, "COUNTING_ROD_NUMERALS"), new BlockRange(119808, 120831, "MATHEMATICAL_ALPHANUMERIC_SYMBOLS"), new BlockRange(120832, 121519, "SUTTON_SIGNWRITING"), new BlockRange(122624, 122879, "LATIN_EXTENDED_G"), new BlockRange(122880, 122927, "GLAGOLITIC_SUPPLEMENT"), new BlockRange(122928, 123023, "CYRILLIC_EXTENDED_D"), new BlockRange(123136, 123215, "NYIAKENG_PUACHUE_HMONG"), new BlockRange(123536, 123583, "TOTO"), new BlockRange(123584, 123647, "WANCHO"), new BlockRange(124112, 124159, "NAG_MUNDARI"), new BlockRange(124896, 124927, "ETHIOPIC_EXTENDED_B"), new BlockRange(124928, 125151, "MENDE_KIKAKUI"), new BlockRange(125184, 125279, "ADLAM"), new BlockRange(126064, 126143, "INDIC_SIYAQ_NUMBERS"), new BlockRange(126208, 126287, "OTTOMAN_SIYAQ_NUMBERS"), new BlockRange(126464, 126719, "ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS"), new BlockRange(126976, 127023, "MAHJONG_TILES"), new BlockRange(127024, 127135, "DOMINO_TILES"), new BlockRange(127136, 127231, "PLAYING_CARDS"), new BlockRange(127232, 127487, "ENCLOSED_ALPHANUMERIC_SUPPLEMENT"), new BlockRange(127488, 127743, "ENCLOSED_IDEOGRAPHIC_SUPPLEMENT"), new BlockRange(127744, 128511, "MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS"), new BlockRange(128512, 128591, "EMOTICONS"), new BlockRange(128592, 128639, "ORNAMENTAL_DINGBATS"), new BlockRange(128640, 128767, "TRANSPORT_AND_MAP_SYMBOLS"), new BlockRange(128768, 128895, "ALCHEMICAL_SYMBOLS"), new BlockRange(128896, 129023, "GEOMETRIC_SHAPES_EXTENDED"), new BlockRange(129024, 129279, "SUPPLEMENTAL_ARROWS_C"), new BlockRange(129280, 129535, "SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS"), new BlockRange(129536, 129647, "CHESS_SYMBOLS"), new BlockRange(129648, 129791, "SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A"), new BlockRange(129792, 130047, "SYMBOLS_FOR_LEGACY_COMPUTING"), new BlockRange(131072, 173791, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B"), new BlockRange(173824, 177983, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C"), new BlockRange(177984, 178207, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D"), new BlockRange(178208, 183983, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E"), new BlockRange(183984, 191471, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F"), new BlockRange(194560, 195103, "CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT"), new BlockRange(196608, 201551, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G"), new BlockRange(201552, 205743, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H"), new BlockRange(917504, 917631, "TAGS"), new BlockRange(917760, 917999, "VARIATION_SELECTORS_SUPPLEMENT"), new BlockRange(983040, 1048575, "SUPPLEMENTARY_PRIVATE_USE_AREA_A"), new BlockRange(0x100000, 0x10FFFF, "SUPPLEMENTARY_PRIVATE_USE_AREA_B")};

    private UnicodeBlocks() {
        for (BlockRange blockRange : BLOCK_RANGES) {
            try {
                Character.UnicodeBlock block = Character.UnicodeBlock.forName(blockRange.id);
                this.blockRangeMap.put(block, blockRange);
            }
            catch (IllegalArgumentException ex) {
                LOG.trace("Unicode block not found: {}", (Object)blockRange.id);
            }
        }
    }

    public static UnicodeBlocks getInstance() {
        return Holder.INSTANCE;
    }

    public BlockRange getRange(Character.UnicodeBlock block) {
        return this.blockRangeMap.get(block);
    }

    public static final class BlockRange {
        private final int min;
        private final int max;
        private final String id;

        private BlockRange(int min, int max, String id) {
            this.min = min;
            this.max = max;
            this.id = id;
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }
    }

    private static final class Holder {
        private static final UnicodeBlocks INSTANCE = new UnicodeBlocks();

        private Holder() {
        }
    }
}

