/*
 * Copyright 2022-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.instancio.generator.specs.bra;

import org.instancio.generator.specs.NullableGeneratorSpec;

/**
 * Spec for generating <a href="https://pt.wikipedia.org/wiki/T%C3%ADtulo_de_eleitor">
 * Brazilian 'Titulo de Eleitor'</a> .
 *
 * @since 5.0.0
 */
public interface TituloEleitoralGeneratorSpec extends NullableGeneratorSpec<String> {

    /**
     * {@inheritDoc}
     *
     * @since 5.0.0
     */
    @Override
    TituloEleitoralGeneratorSpec nullable();
}
