/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.instancio.internal.ApiValidator;
import org.instancio.junit.Given;
import org.instancio.junit.GivenProvider;

public class ElementAnnotations {
    private final List<Annotation> annotations;
    private final List<Class<? extends GivenProvider>> providerClasses;

    public ElementAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
        this.providerClasses = annotations.stream().filter(a -> a.annotationType() == Given.class).flatMap(a -> Arrays.stream(((Given)a).value())).distinct().collect(Collectors.toList());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        List results = this.annotations.stream().filter(a -> a.annotationType() == annotationType).collect(Collectors.toList());
        if (results.isEmpty()) {
            return null;
        }
        ApiValidator.isFalse((results.size() > 1 ? 1 : 0) != 0, (String)"Found multiple annotations of type %s", (Object[])new Object[]{annotationType.getName()});
        return (A)((Annotation)results.get(0));
    }

    public List<Class<? extends GivenProvider>> getProviderClasses() {
        return this.providerClasses;
    }
}

