/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IBatchStatement;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.iternine.jeppetto.testsupport.db.ConnectionSource;

public abstract class Database {
    private ConnectionSource connectionSource;

    public Database(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public abstract void close();

    protected abstract void onNewIDatabaseConnection(IDatabaseConnection var1);

    public void loadXmlDataSetResource(String resourceName) {
        this.loadXmlDataSet(Database.class.getResourceAsStream(resourceName));
    }

    public void loadXmlDataSet(InputStream inputStream) {
        IDatabaseConnection databaseConnection = null;
        try {
            databaseConnection = this.getIDatabaseConnection();
            XmlDataSet dataSet = new XmlDataSet(inputStream);
            DatabaseOperation.REFRESH.execute(databaseConnection, (IDataSet)dataSet);
        }
        catch (DatabaseUnitException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (databaseConnection != null) {
                try {
                    databaseConnection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void writeXmlDataSet(OutputStream outputStream) {
        this.writeXmlDataSet(outputStream, null);
    }

    public void writeXmlDataSet(OutputStream outputStream, String[] tables) {
        IDatabaseConnection databaseConnection = null;
        try {
            databaseConnection = this.getIDatabaseConnection();
            DatabaseSequenceFilter sequenceFilter = new DatabaseSequenceFilter(databaseConnection);
            FilteredDataSet dataSet = new FilteredDataSet((ITableFilter)sequenceFilter, databaseConnection.createDataSet());
            if (tables != null) {
                dataSet = new FilteredDataSet(tables, (IDataSet)dataSet);
            }
            XmlDataSet.write((IDataSet)dataSet, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (databaseConnection != null) {
                try {
                    databaseConnection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void clearDatabase() {
        IDatabaseConnection databaseConnection = null;
        try {
            databaseConnection = this.getIDatabaseConnection();
            DatabaseSequenceFilter sequenceFilter = new DatabaseSequenceFilter(databaseConnection);
            FilteredDataSet dataSet = new FilteredDataSet((ITableFilter)sequenceFilter, databaseConnection.createDataSet());
            DatabaseOperation.DELETE_ALL.execute(databaseConnection, (IDataSet)dataSet);
        }
        catch (DatabaseUnitException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (databaseConnection != null) {
                try {
                    databaseConnection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void executeArbitrarySql(String sql) {
        IDatabaseConnection databaseConnection = null;
        IBatchStatement statement = null;
        try {
            databaseConnection = this.getIDatabaseConnection();
            DatabaseConfig databaseConfig = databaseConnection.getConfig();
            IStatementFactory statementFactory = (IStatementFactory)databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
            statement = statementFactory.createBatchStatement(databaseConnection);
            statement.addBatch(sql);
            statement.executeBatch();
            statement.clearBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignore) {}
            }
            if (databaseConnection != null) {
                try {
                    databaseConnection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    protected IDatabaseConnection getIDatabaseConnection() throws SQLException {
        DatabaseConnection connection;
        try {
            connection = new DatabaseConnection(this.connectionSource.getConnection());
        }
        catch (DatabaseUnitException e) {
            throw new SQLException(e);
        }
        this.onNewIDatabaseConnection((IDatabaseConnection)connection);
        return connection;
    }
}

