/*
 * Decompiled with CFR 0.152.
 */
package org.iternine.jeppetto.testsupport.db;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.FilteredTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.filter.DefaultTableFilter;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.iternine.jeppetto.testsupport.db.Database;

public class DatabaseAssert {
    public static void assertDatabaseContentsEqualsResource(Database database, String resource) {
        DatabaseAssert.assertDatabaseContentsEqualsResource(database, resource, new String[0]);
    }

    public static void assertDatabaseContentsEqualsResource(Database database, String resource, String[] ignoreList) {
        HashMap<String, String[]> ignoreMap = new HashMap<String, String[]>();
        ignoreMap.put("*", ignoreList);
        DatabaseAssert.assertDatabaseContentsEqualsResource(database, resource, ignoreMap);
    }

    public static void assertDatabaseContentsEqualsResource(Database database, String resource, Map<String, String[]> ignoreMap) {
        DatabaseAssert.assertDatabaseContentsEquals(database, DatabaseAssert.class.getResourceAsStream(resource), ignoreMap);
    }

    public static void assertDatabaseContentsEquals(Database database, InputStream inputStream) {
        DatabaseAssert.assertDatabaseContentsEquals(database, inputStream, new String[0]);
    }

    public static void assertDatabaseContentsEquals(Database database, InputStream inputStream, String[] ignoreList) {
        HashMap<String, String[]> ignoreMap = new HashMap<String, String[]>();
        ignoreMap.put("*", ignoreList);
        DatabaseAssert.assertDatabaseContentsEquals(database, inputStream, ignoreMap);
    }

    public static void assertDatabaseContentsEquals(Database database, InputStream inputStream, Map<String, String[]> ignoreMap) {
        Map<ITableFilter, IColumnFilter> filterMap = DatabaseAssert.createFilterMap(ignoreMap);
        try {
            String[] expectedTableNames;
            IDataSet databaseDataSet = database.getIDatabaseConnection().createDataSet();
            IDataSet actualDataSet = DatabaseAssert.removeIgnoredColumns(databaseDataSet, filterMap);
            XmlDataSet xmlDataSet = new XmlDataSet(inputStream);
            IDataSet expectedDataSet = DatabaseAssert.removeIgnoredColumns((IDataSet)xmlDataSet, filterMap);
            for (String expectedTableName : expectedTableNames = expectedDataSet.getTableNames()) {
                Assertion.assertEquals((ITable)new SortedTable(expectedDataSet.getTable(expectedTableName)), (ITable)new SortedTable(actualDataSet.getTable(expectedTableName), expectedDataSet.getTable(expectedTableName).getTableMetaData()));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
        catch (DatabaseUnitException e) {
            throw new AssertionFailedError(e.getMessage());
        }
    }

    private static Map<ITableFilter, IColumnFilter> createFilterMap(Map<String, String[]> ignoreMap) {
        HashMap<ITableFilter, IColumnFilter> filterMap = new HashMap<ITableFilter, IColumnFilter>();
        for (Map.Entry<String, String[]> e : ignoreMap.entrySet()) {
            DefaultTableFilter tables = new DefaultTableFilter();
            DefaultColumnFilter columnFilter = new DefaultColumnFilter();
            tables.includeTable(e.getKey());
            for (String columnPattern : e.getValue()) {
                columnFilter.excludeColumn(columnPattern);
            }
            filterMap.put((ITableFilter)tables, (IColumnFilter)columnFilter);
        }
        return filterMap;
    }

    private static IDataSet removeIgnoredColumns(IDataSet dataSet, Map<ITableFilter, IColumnFilter> columnFilterMap) throws DataSetException {
        DefaultDataSet filteredDataSet = new DefaultDataSet();
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            ITable table = iterator.getTable();
            for (Map.Entry<ITableFilter, IColumnFilter> e : columnFilterMap.entrySet()) {
                if (!e.getKey().accept(table.getTableMetaData().getTableName())) continue;
                table = DatabaseAssert.filterTable(table, e.getValue());
            }
            filteredDataSet.addTable(table);
        }
        return filteredDataSet;
    }

    private static ITable filterTable(ITable table, IColumnFilter filter) throws DataSetException {
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), filter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }
}

